/*
 * e2list.0.c
 * Copyright (C) 2008-2011, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4-m.0.h>
#include <e2list-defs.h>
#include <e2list-types.h>

static int init_list(struct e2list_type *, unsigned, struct screen_type *);
static int link_list(struct e2list_type *, unsigned);

static int
init_list(struct e2list_type *e2list_data, unsigned bits,
	  struct screen_type *screen_data)
{
    if (bits & FLATLINE_LINK) {
	e2list_data->link_l.class = screen_data->link_l.class;
    } else {
	e2list_data->link_l.class = NULL;
    }

    if (bits & MISSLINK_LINK) {
	e2list_data->link_a.data = screen_data->link_a.data;
	e2list_data->link_a.free = screen_data->link_a.free;
	e2list_data->link_a.link = screen_data->link_a.link;
	e2list_data->link_a.mode = screen_data->link_a.mode;
    } else {
	e2list_data->link_a.data = NULL;
	e2list_data->link_a.free = _x1f4_e4_free_data;
	e2list_data->link_a.link = _x1f4_e4_link_data;
	e2list_data->link_a.mode = _x1f4_e4_mode_data;
    }

    if (bits & RESOURCE_LINK) {
	e2list_data->link_m.data = screen_data->link_m.data;
	e2list_data->link_m.free = screen_data->link_m.free;
	e2list_data->link_m.link = screen_data->link_m.link;
	e2list_data->link_m.mode = screen_data->link_m.mode;
    } else {
	e2list_data->link_m.data = NULL;
	e2list_data->link_m.free = _x1f4_e4_free_data;
	e2list_data->link_m.link = _x1f4_e4_link_data;
	e2list_data->link_m.mode = _x1f4_e4_mode_data;
    }

    return link_list(e2list_data, bits);
}


static int
link_list(struct e2list_type *e2list_data, unsigned bits)
{
    int status;

    if (bits & SCHEDULE_FINE) {
	void *fine;

	status = e2list_data->link_a.link
	    (e2list_data->link_a.data, &fine, FINE_SIZE);
	if (status) {
	    status = LINK_ERROR;
	} else {
	    unsigned size;

	    size = sizeof(struct e2fine_type);
	    size += (16 - (size & 15)) & 15;

	    e2list_data->link_c.list = NULL;
	    e2list_data->link_e.list = NULL;

	    e2list_data->link_i.call = size;
	    e2list_data->link_i.deck = fine;
	    e2list_data->link_i.fine = fine;
	    e2list_data->link_i.hold = NULL;
	    e2list_data->link_i.slip = size;

	    ((struct e2fine_type *) fine)->e2fine_data = NULL;
	}
    } else {
	status = 0;

	e2list_data->link_c.list = NULL;
	e2list_data->link_e.list = NULL;

	e2list_data->link_i.call = ~0;
	e2list_data->link_i.deck = NULL;
	e2list_data->link_i.fine = NULL;
	e2list_data->link_i.hold = NULL;
	e2list_data->link_i.slip = ~0;
    }

    return status;
}


int
x1f4_init_e2list(void **e2list, unsigned bits, struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *list, *text;

    if (bits & RESOURCE_LINK) {
	link = screen_data->link_m.link;
	text = screen_data->link_m.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &list, sizeof(struct e2list_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_list(list, bits, screen_data);
	if (status) {
	    if (bits & RESOURCE_LINK) {
		screen_data->link_m.free(text, list);
	    } else {
		_x1f4_e4_free_data(text, list);
	    }
	} else {
	    *e2list = list;
	}
    }

    return status;
}
