/*
 * e101.h
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __Mylene101_H__
#define __Mylene101_H__

#include <sys/time.h>

#define Mylene101_BUSY_ERROR		-129
#define Mylene101_FARE_ERROR		-130
#define Mylene101_FINI_ERROR		-131
#define Mylene101_FREE_ERROR		-132
#define Mylene101_LINK_ERROR		-133
#define Mylene101_MODE_ERROR		-134
#define Mylene101_POLL_ERROR		-135
#define Mylene101_READ_ERROR		-136
#define Mylene101_SEND_ERROR		-137

#define Mylene101_EVER_MATCH		1024
#define Mylene101_MISS_CLASS		1025

#define Mylene101_READ_CLASS		0
#define Mylene101_SEND_CLASS		1

#define Mylene101_DEVICE_RESOURCE	(1L << 1)
#define Mylene101_DEVICE_TEXTFLAT	(1L << 2)

#if !defined __x1f4_track_type_defined__
typedef struct x1f4_track_type {
    int (*line) (void *), (*post) (void *),
	(*push) (void *, const char *, unsigned);
    void *data;
} x1f4_track_type;
#endif				/* !__x1f4_track_type_defined__ */

#if !defined __x1f4_track_type_defined__
# define __x1f4_track_type_defined__
#endif				/* !__x1f4_track_type_defined__ */

#if !defined __x1f4_trans_type_defined__
typedef struct x1f4_trans_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned);
    void *data;
} x1f4_trans_type;
#endif				/* !__x1f4_trans_type_defined__ */

#if !defined __x1f4_trans_type_defined__
# define __x1f4_trans_type_defined__
#endif				/* !__x1f4_trans_type_defined__ */

typedef struct Mylene101_access_type {
    int (*fini) (void *, void *), (*line) (void *, void *);
    void *text;
} Mylene101_access_type;

typedef struct Mylene101_agenda_type {
    int (*fare) (void *, void *), (*fini) (void *, void *);
    void *text;
} Mylene101_agenda_type;

typedef struct Mylene101_device_type {
    struct x1f4_track_type textflat_set;
    struct x1f4_trans_type resource_set;
} Mylene101_device_type;

typedef struct Mylene101_legend_type {
    int (*fare) (void *, void *), (*fini) (void *, void *);
    void *text;
} Mylene101_legend_type;

extern int Mylene101_call_access(void *, void *, int, int);
extern int Mylene101_case_access(void *, void *);
extern int Mylene101_fail_device(void *);
extern int Mylene101_find_access(void *, int, int, void **);
extern int Mylene101_fini_device(void **, void *);
extern int Mylene101_high_device(void *, void *);
extern int Mylene101_init_device
    (void **, unsigned, struct Mylene101_device_type *);
extern int Mylene101_line_device(void *, void *);
extern int Mylene101_link_access
    (void *, int, int, struct Mylene101_access_type *, void **);
extern int Mylene101_miss_access(void *, void *, int);
extern int Mylene101_near_device(void *);
extern int Mylene101_post_access
    (void *, int, struct Mylene101_access_type *, void **);
extern int Mylene101_push_access
    (void *, int, struct Mylene101_access_type *, void **);
extern int Mylene101_push_agenda
    (void *, struct timeval *, struct Mylene101_agenda_type *, void **);
extern int Mylene101_push_legend
    (void *, struct Mylene101_legend_type *, void **);
extern int Mylene101_read_access(void *, void *, int (*) (void *, void *));
extern int Mylene101_slip_access(void *, void *, void *);
extern int Mylene101_slip_agenda(void *, void *, void *);
extern int Mylene101_slip_legend(void *, void *, void *);

#endif				/* __Mylene101_H__ */
