/*
 * e101-types.h
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __Mylene101_types_H__
#define __Mylene101_types_H__

#include <track.h>
#include <trans.h>

#include <sys/time.h>

typedef struct access_type {
    int (*fini) (void *, void *), (*line) (void *, void *);
    void *text;
} access_type;

typedef struct agenda_type {
    int (*fare) (void *, void *), (*fini) (void *, void *);
    void *text;
} agenda_type;

typedef struct clause_type {
    int fd;
    struct access_type access;
    struct clause_type *miss_clause, *post_clause;
    unsigned bits;
} clause_type;

typedef struct effect_type {
    struct agenda_type *agenda_data;
    struct timeval effect;
} effect_type;

typedef struct legend_type {
    int (*fare) (void *, void *), (*fini) (void *, void *);
    void *text;
} legend_type;

typedef struct method_type {
    struct legend_type legend;
    struct method_type *miss_method, *post_method;
} method_type;

typedef struct screen_type {
    struct x1f4_track_type link_e;
    struct x1f4_trans_type link_m;
} screen_type;

#endif				/* __Mylene101_types_H__ */
