/*
 * e101-sx.7.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e101-access.h>
#include <e101-errors.h>
#include <e101-inter.h>
#include <e101-names.h>
#include <e101-types.h>

static int fare_slip(void *, void *);

static int
fare_slip(void *fare, void *slip)
{
    return 0;
}


int
Mylene101_slip_agenda(void *device, void *reflex, void *agenda)
{
    int (*fini) (void *, void *), status;
    struct agenda_type *agenda_data;

    agenda_data = agenda;

    agenda_data->fare = fare_slip;

    fini = agenda_data->fini;
    if (fini) {
	agenda_data->fini = NULL;

	status = fini(reflex, agenda_data->text);
	if (status) {
	    EXCESS(device) = status;
	    status = FINI_ERROR;
	}
    } else {
	status = 0;
    }

    return status;
}
