/*
 * e101-sx.0.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <unistd.h>

#include <sys/select.h>
#include <sys/time.h>
#include <sys/types.h>

#include <bqfset.h>
#include <e101-access.h>
#include <e101-errors.h>
#include <e101-inter.h>
#include <e101-names.h>
#include <e101-types.h>

int
Mylene101_push_agenda(void *device, struct timeval *effect,
		      struct agenda_type *agenda_data, void **push)
{
    int status;
    void *agenda;

    status = LINK_M(device).link
	(LINK_M(device).data, &agenda, sizeof(struct agenda_type));
    if (status) {
	status = _Mylene101_stat_link(device);
    } else {
	struct agenda_type *agenda_call;
	struct effect_type affect;
	void *data;

	agenda_call = agenda;

	affect.effect = *effect;

	status = x1f4_post_bqfset(ESET(device), &affect, &data);
	if (status) {
	    status = _Mylene101_stat_link(device);
	} else {
	    struct effect_type *effect_data;

	    EXTENT(device)++;

	    effect_data = data;

	    effect_data->agenda_data = agenda_call;
	    effect_data->effect = *effect;

	    if (push) {
		*push = agenda_call;
	    }

	    *agenda_call = *agenda_data;
	}
    }

    return status;
}
