/*
 * e101-sv.7.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e101-access.h>
#include <e101-errors.h>
#include <e101-defs.h>
#include <e101-inter.h>
#include <e101-names.h>
#include <e101-types.h>

int
Mylene101_slip_legend(void *device, void *reflex, void *legend)
{
    int excess, (*fini) (void *, void *), status = 0;
    struct method_type *method_data, *miss_method, *post_method;

    method_data = (void *)
	((char *) legend - offsetof(struct method_type, legend));

    miss_method = method_data->miss_method;
    post_method = method_data->post_method;

    fini = method_data->legend.fini;
    if (fini) {
	status = fini(reflex, method_data->legend.text);
	if (status) {
	    EXCESS(device) = status;
	    status = FINI_ERROR;
	}
    }

    excess = LINK_M(device).free(LINK_M(device).data, method_data);
    if (excess) {
	if (status) {
	} else {
	    status = _Mylene101_stat_free(device);
	}
    }

    {
	EXTENT(device)--;

	if (miss_method) {
	    miss_method->post_method = post_method;
	} else {
	    METHOD(device) = post_method;
	}
	if (post_method) {
	    post_method->miss_method = miss_method;
	} else {
	    TICKET(device) = miss_method;
	}
    }

    return status;
}
