/*
 * e101-sv.0.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e101-access.h>
#include <e101-errors.h>
#include <e101-inter.h>
#include <e101-names.h>
#include <e101-types.h>

int
Mylene101_push_legend(void *device, struct legend_type *legend_data,
		      void **push)
{
    int status;
    void *data;

    status = LINK_M(device).link
	(LINK_M(device).data, &data, sizeof(struct method_type));
    if (status) {
	status = _Mylene101_stat_link(device);
    } else {
	struct method_type *method_data, *method_slip;

	EXTENT(device)++;

	method_data = data;

	method_data->post_method = NULL;

	method_slip = TICKET(device);
	if (method_slip) {
	    method_data->miss_method = method_slip;
	    method_slip->post_method = method_data;
	} else {
	    METHOD(device) = method_data;
	    method_data->miss_method = NULL;
	}

	TICKET(device) = method_data;

	if (push) {
	    *push = &method_data->legend;
	}

	method_data->legend = *legend_data;
    }

    return status;
}
