/*
 * e101-state.h
 * Copyright (C) 2008-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __Mylene101_state_H__
#define __Mylene101_state_H__

#include <unistd.h>

#include <sys/time.h>
#include <sys/types.h>

#include <e101-types.h>
#include <trans.h>

typedef struct weekly_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } link_e;
} weekly_type;

typedef struct device_state {
    fd_set set_0, set_1;
    int excess, nfds;
    struct clause_type *clause_data, *clause_long, *clause_slip;
    struct method_type *method_data, *method_slip;
    struct trans_type link_m;
    struct weekly_type weekly;
    unsigned extent, scheduled;
    void *eset;
} device_state;

#endif				/* __Mylene101_state_H__ */
