/*
 * e101-se.7.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e101-defs.h>
#include <e101-errors.h>
#include <e101-inter.h>
#include <e101-names.h>
#include <e101-types.h>

int
Mylene101_miss_access(void *device, void *reflex, int fd)
{
    int excess, status;

    status = _Mylene101_call_case(device, reflex, fd, 0);

    excess = _Mylene101_call_case(device, reflex, fd, CLAUSE_OUTPUT);
    if (excess) {
	if (status) {
	    if (status == MISS_CLASS) {
		status = excess;
	    }
	} else {
	    if (excess != MISS_CLASS) {
		status = excess;
	    }
	}
    } else {
	if (status == MISS_CLASS) {
	    status = 0;
	}
    }

    return status;
}
