/*
 * e101-se.4.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <unistd.h>
#include <stddef.h>

#include <sys/select.h>
#include <sys/types.h>

#include <e101-access.h>
#include <e101-defs.h>
#include <e101-names.h>
#include <e101-types.h>

int
Mylene101_case_access(void *device, void *access)
{
    struct clause_type *clause_data;

    clause_data = (void *)
	((char *) access - offsetof(struct clause_type, access));

    return FD_ISSET(clause_data->fd, &SET_1(device)) ? CLAUSE_OUTPUT : 0;
}
