/*
 * e101-se.3.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <unistd.h>

#include <sys/select.h>
#include <sys/time.h>
#include <sys/types.h>

#include <e101-access.h>
#include <e101-defs.h>
#include <e101-errors.h>
#include <e101-inter.h>
#include <e101-names.h>
#include <e101-types.h>

int
Mylene101_link_access(void *device, int fd, int df,
		      struct access_type *access_data, void **link)
{
    int status;

    do {
	struct clause_type *clause_data;
	void *data;

	if (_Mylene101_pick_case(device, fd, df, &data)) {
	    status = EVER_MATCH;
	    if (1) {
		break;
	    }
	}

	status = LINK_M(device).link
	    (LINK_M(device).data, &data, sizeof(struct clause_type));
	if (status) {
	    status = _Mylene101_stat_link(device);
	    if (1) {
		break;
	    }
	} else {
	    struct clause_type *post_clause;

	    clause_data = data;

	    post_clause = CLAUSE(device);
	    if (post_clause) {
		post_clause->miss_clause = clause_data;
		clause_data->post_clause = post_clause;
		clause_data->miss_clause = NULL;
	    } else {
		clause_data->miss_clause = NULL;
		clause_data->post_clause = NULL;
	    }

	    CLAUSE(device) = data;
	}

	if (fd < NFDS(device)) {
	} else {
	    NFDS(device) = fd + 1;
	}

	EXTENT(device)++;

	clause_data->fd = fd;

	if (df) {
	    clause_data->bits = CLAUSE_OUTPUT;
	    if (1) {
		FD_SET(fd, &SET_1(device));
	    }
	} else {
	    clause_data->bits = 0;
	    if (1) {
		FD_SET(fd, &SET_0(device));
	    }
	}

	if (link) {
	    *link = &clause_data->access;
	}

	clause_data->access = *access_data;
    } while (0);

    return status;
}
