/*
 * e101-sa.6.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <bqfset.h>
#include <e101-access.h>
#include <e101-errors.h>
#include <e101-inter.h>
#include <e101-names.h>
#include <e101-state.h>

typedef struct render_type {
    int status;
    void *device, *reflex;
} render_type;

static int free_clause(struct device_state *, struct clause_type *, void *);
static int free_method(struct device_state *, struct method_type *, void *);
static int slip_effect(void *, void *);

static int
free_clause(struct device_state *device_data, struct clause_type *clause_data,
	    void *reflex)
{
    int status = 0;

    while (clause_data) {
	int excess, (*fini) (void *, void *);
	struct clause_type *post_clause;

	post_clause = clause_data->post_clause;

	fini = clause_data->access.fini;
	if (fini) {
	    excess = fini(reflex, clause_data->access.text);
	    if (excess) {
		if (status) {
		} else {
		    device_data->excess = excess;
		    status = FINI_ERROR;
		}
	    }
	}

	excess = device_data->link_m.free
	    (device_data->link_m.data, clause_data);
	if (excess) {
	    if (status) {
	    } else {
		status = _Mylene101_stat_free(device_data);
	    }
	}

	clause_data = post_clause;
    }

    return status;
}


static int
free_method(struct device_state *device_data, struct method_type *method_data,
	    void *reflex)
{
    int status = 0;

    while (method_data) {
	int excess, (*fini) (void *, void *);
	struct method_type *post_method;

	post_method = method_data->post_method;

	fini = method_data->legend.fini;
	if (fini) {
	    excess = fini(reflex, method_data->legend.text);
	    if (excess) {
		if (status) {
		} else {
		    device_data->excess = excess;
		    status = FINI_ERROR;
		}
	    }
	}

	excess = device_data->link_m.free
	    (device_data->link_m.data, method_data);
	if (excess) {
	    if (status) {
	    } else {
		status = _Mylene101_stat_free(device_data);
	    }
	}

	method_data = post_method;
    }

    return status;
}


static int
slip_effect(void *call, void *effect)
{
    int excess, (*fini) (void *, void *), status;
    struct agenda_type *agenda_data;
    struct effect_type *effect_data;
    struct render_type *render_data;
    void *device;

    effect_data = effect;

    render_data = call;

    device = render_data->device;

    agenda_data = effect_data->agenda_data;

    fini = agenda_data->fini;
    if (fini) {
	status = fini(render_data->reflex, agenda_data->text);
	if (status) {
	    if (render_data->status) {
	    } else {
		EXCESS(device) = status;
		render_data->status = FINI_ERROR;
	    }
	}
    } else {
	status = 0;
    }

    excess = LINK_M(device).free(LINK_M(device).data, agenda_data);
    if (excess) {
	if (status) {
	} else {
	    status = _Mylene101_stat_free(device);
	}
    }

    return status;
}


int
Mylene101_high_device(void *device, void *reflex)
{
    int excess, status = 0;
    struct clause_type *clause_data;
    struct method_type *method_data;
    void *data;

    clause_data = CLAUSE(device);
    if (clause_data) {
	CLAUSE(device) = NULL;
	status = free_clause(device, clause_data, reflex);
    }

    method_data = METHOD(device);
    if (method_data) {
	METHOD(device) = NULL;
	excess = free_method(device, method_data, reflex);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    data = ESET(device);
    if (data) {
	struct render_type render;

	ESET(device) = NULL;

	render.device = device;
	render.reflex = reflex;
	render.status = status;

	x1f4_lime_bqfset(data, &render, slip_effect);

	status = render.status;

	excess = x1f4_fini_bqfset(&data);
	if (excess) {
	    if (status) {
	    } else {
		status = _Mylene101_stat_free(device);
	    }
	}
    }

    return status;
}
