/*
 * e101-sa.4.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <stddef.h>
#include <string.h>
#include <unistd.h>

#include <sys/select.h>
#include <sys/time.h>
#include <sys/types.h>

#include <bqfset.h>
#include <e101-access.h>
#include <e101-defs.h>
#include <e101-errors.h>
#include <e101-inter.h>
#include <e101-names.h>
#include <e101-types.h>

#define SECOND_a(v)			((v).tv_sec)
#define SECOND_f(v)			((v).tv_usec)

static int line_device(void *, void *);

static int
line_device(void *device, void *reflex)
{
    fd_set fd_set_0, fd_set_1, *set_0, *set_1, *set_o, *set_l;
    int status = 0;

    set_l = &SET_1(device);
    set_o = &SET_0(device);

    set_0 = &fd_set_0;
    set_1 = &fd_set_1;

    while (SCHEDULED_EXTENT(device)) {
	struct method_type *method_data;
	struct timeval *linetrap, timeout;

	memcpy(set_0, set_o, sizeof(fd_set));
	memcpy(set_1, set_l, sizeof(fd_set));

	method_data = METHOD(device);

	if (method_data) {
	    SECOND_a(timeout) = 0;
	    SECOND_f(timeout) = 0;
	    if (1) {
		linetrap = &timeout;
	    }
	} else {
	    void *data;

	    if (x1f4_lead_bqfset(ESET(device), &data)) {
		linetrap = NULL;
	    } else {
		struct effect_type *effect_data;
		struct timeval now;
		unsigned second_a, second_f;

		effect_data = data;

		second_a = SECOND_a(effect_data->effect);
		second_f = SECOND_f(effect_data->effect);

		gettimeofday(&now, NULL);
		if (second_a < SECOND_a(now)) {
		    SECOND_a(timeout) = 0;
		    SECOND_f(timeout) = 0;
		} else {
		    if (second_a ^ SECOND_a(now)) {
			SECOND_a(timeout) = second_a - SECOND_a(now);
			if (second_f < SECOND_f(now)) {
			    SECOND_a(timeout)--;
			    second_f += 1000000;
			} else {
			}

			SECOND_f(timeout) = second_f - SECOND_f(now);
		    } else {
			SECOND_a(timeout) = 0;
			if (SECOND_f(now) < second_f) {
			    SECOND_f(timeout) = second_f - SECOND_f(now);
			} else {
			    SECOND_f(timeout) = 0;
			}
		    }
		}

		linetrap = &timeout;
	    }
	}

	status = select(NFDS(device), set_0, set_1, NULL, linetrap);
	if (status < 0) {
	    if (errno != EINTR) {
		status = _Mylene101_stat_poll(device, errno);
		break;
	    }
	} else {
	    if (status) {
		struct clause_type *clause_data;
		unsigned count;

		COURSE(device) = NULL;

		method_data = NULL;

		count = status;

		status = 0;

		clause_data = CLAUSE(device);
		while (clause_data) {
		    int clause, excess;
		    struct clause_type *post_clause;

		    post_clause = clause_data->post_clause;
		    if (post_clause) {
			post_clause->miss_clause = NULL;
		    } else {
		    }
		    if (0) {
		    } else {
			CLAUSE(device) = post_clause;
		    }

		    clause = clause_data->fd;

		    if (clause_data->bits & CLAUSE_OUTPUT) {
			if (FD_ISSET(clause, set_1)) {
			    excess = SEND_ERROR;
			} else {
			    excess = 0;
			}
		    } else {
			if (FD_ISSET(clause, set_0)) {
			    excess = READ_ERROR;
			} else {
			    excess = 0;
			}
		    }

		    post_clause = PERIOD(device);
		    if (post_clause) {
			if (excess) {
			    clause_data->post_clause = post_clause;
			    post_clause->miss_clause = clause_data;
			    PERIOD(device) = clause_data;
			    clause_data->miss_clause = NULL;
			} else {
			    post_clause = COURSE(device);
			    clause_data->miss_clause = post_clause;
			    post_clause->post_clause = clause_data;
			    COURSE(device) = clause_data;
			    clause_data->post_clause = NULL;
			}
		    } else {
			COURSE(device) = clause_data;
			PERIOD(device) = clause_data;
			clause_data->miss_clause = NULL;
			clause_data->post_clause = NULL;
		    }

		    if (excess) {
			status = clause_data->access.line
			    (reflex, clause_data->access.text);
			if (status) {
			    EXCESS(device) = status;
			    status = excess;
			    break;
			} else {
			    count--;
			    if (count) {
			    } else {
				break;
			    }
			}
		    }

		    if (!SCHEDULED(device)) {
			break;
		    }

		    clause_data = CLAUSE(device);
		}

		clause_data = COURSE(device);
		if (clause_data) {
		    clause_data->post_clause = CLAUSE(device);
		    CLAUSE(device) = PERIOD(device);
		    PERIOD(device) = NULL;
		}

		if (status | !SCHEDULED(device)) {
		    break;
		}
	    }

	    if (1) {
		void *data;

		if (x1f4_lead_bqfset(ESET(device), &data)) {
		} else {
		    struct effect_type *effect_data;
		    struct timeval now;
		    unsigned second_a, second_f;

		    effect_data = data;

		    second_a = SECOND_a(effect_data->effect);
		    second_f = SECOND_f(effect_data->effect);

		    gettimeofday(&now, NULL);
		    if (second_a < SECOND_a(now)) {
		    } else {
			if (second_a ^ SECOND_a(now)) {
			    data = NULL;
			} else {
			    if (SECOND_f(now) < second_f) {
				data = NULL;
			    } else {
			    }
			}
		    }

		    if (data) {
			status = _Mylene101_link_fair(device, reflex, data);
			if (status) {
			    break;
			} else {
			    method_data = NULL;
			}
		    }

		    if (!SCHEDULED(device)) {
			break;
		    }
		}
	    }

	    if (method_data) {
		status = method_data->legend.fare
		    (reflex, method_data->legend.text);
		if (status) {
		    EXCESS(device) = status;
		    status = FARE_ERROR;
		    break;
		} else {
		    method_data = METHOD(device);
		    if (method_data) {
			struct method_type *post_method;

			post_method = method_data->post_method;
			if (post_method) {
			    struct method_type *method_slip;

			    method_slip = TICKET(device);

			    method_slip->post_method = method_data;
			    method_data->miss_method = method_slip;

			    method_data->post_method = NULL;
			    post_method->miss_method = NULL;

			    TICKET(device) = method_data;
			    METHOD(device) = post_method;
			}
		    }
		}
	    }
	}
    }

    return status;
}


int
Mylene101_line_device(void *device, void *reflex)
{
    int status;

    if (SCHEDULED(device)) {
	status = _Mylene101_stat_busy(device);
    } else {
	SCHEDULED(device) = ~0;
	if (1) {
	    status = line_device(device, reflex);
	    if (1) {
		SCHEDULED(device) = 0;
	    }
	}
    }

    return status;
}
