/*
 * e101-sa.0.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * IMPROVEMENTS
 *
 *.replace the linked schedules list with a fast random access list
 *.replace the linked connections list with a fast random access list
 */

#include <stddef.h>
#include <unistd.h>

#include <sys/types.h>

#include <e101-break.h>
#include <e101-defs.h>
#include <e101-errors.h>
#include <e101-inter.h>
#include <e101-names.h>
#include <e101-state.h>
#include <e101-types.h>

static int line_device(struct device_state *, unsigned, struct screen_type *);
static int link_device(struct device_state *);

static int
line_device(struct device_state *device_data, unsigned bits,
	    struct screen_type *screen_data)
{
    if (bits & DEVICE_TEXTFLAT) {
	device_data->weekly.link_e.data = screen_data->link_e.data;
	device_data->weekly.link_e.line = screen_data->link_e.line;
	device_data->weekly.link_e.post = screen_data->link_e.post;
	device_data->weekly.link_e.push = screen_data->link_e.push;
    } else {
	device_data->weekly.link_e.line = NULL;
	device_data->weekly.link_e.post = NULL;
	device_data->weekly.link_e.push = NULL;
    }

    if (bits & DEVICE_RESOURCE) {
	device_data->link_m.data = screen_data->link_m.data;
	device_data->link_m.free = screen_data->link_m.free;
	device_data->link_m.link = screen_data->link_m.link;
	device_data->link_m.mode = screen_data->link_m.mode;
    } else {
	device_data->link_m.data = NULL;
	device_data->link_m.free = _Mylene101_free_data;
	device_data->link_m.link = _Mylene101_link_data;
	device_data->link_m.mode = _Mylene101_mode_data;
    }

    return link_device(device_data);
}


static int
link_device(struct device_state *device_data)
{
    int status;

    status = _Mylene101_init_eset(device_data);
    if (status) {
    } else {
	FD_ZERO(&device_data->set_0);
	FD_ZERO(&device_data->set_1);

	device_data->nfds = 0;

	device_data->extent = 0;
	device_data->scheduled = 0;

	device_data->clause_data = NULL;
	device_data->clause_long = NULL;

	device_data->method_data = NULL;
	device_data->method_slip = NULL;
    }

    return status;
}


int
Mylene101_init_device(void **device, unsigned bits,
		      struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *data, *text;

    if (bits & DEVICE_RESOURCE) {
	link = screen_data->link_m.link;
	text = screen_data->link_m.data;
    } else {
	link = _Mylene101_link_data;
	text = NULL;
    }

    status = link(text, &data, sizeof(struct device_state));
    if (status) {
	status = LINK_ERROR;
    } else {
	struct device_state *device_data;

	device_data = data;

	status = line_device(device_data, bits, screen_data);

	if (status) {
	    device_data->link_m.free(device_data->link_m.data, data);
	} else {
	    *device = device_data;
	}
    }

    return status;
}
