/*
 * e101-mv.h.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <unistd.h>

#include <sys/select.h>
#include <sys/time.h>
#include <sys/types.h>

#include <e101-access.h>
#include <e101-errors.h>
#include <e101-inter.h>
#include <e101-names.h>
#include <e101-types.h>

int
_Mylene101_mind_case(void *device, void *reflex,
		     struct clause_type *clause_data, int df)
{
    int excess, fd, (*fini) (void *, void *), status = 0;
    struct clause_type *miss_clause, *post_clause;

    miss_clause = clause_data->miss_clause;
    post_clause = clause_data->post_clause;

    fini = clause_data->access.fini;
    if (fini) {
	status = fini(reflex, clause_data->access.text);
	if (status) {
	    EXCESS(device) = status;
	    status = FINI_ERROR;
	}
    }

    fd = clause_data->fd;

    excess = LINK_M(device).free(LINK_M(device).data, clause_data);
    if (excess) {
	if (status) {
	} else {
	    status = _Mylene101_stat_free(device);
	}
    }

    {
	EXTENT(device)--;

	if (miss_clause) {
	    miss_clause->post_clause = post_clause;
	} else {
	    if (clause_data == CLAUSE(device)) {
		CLAUSE(device) = post_clause;
	    } else {
		if (post_clause) {
		    PERIOD(device) = post_clause;
		} else {
		    COURSE(device) = NULL;
		    PERIOD(device) = NULL;
		}
	    }
	}
	if (post_clause) {
	    post_clause->miss_clause = miss_clause;
	} else {
	}

	if (df) {
	    FD_CLR(fd, &SET_1(device));
	} else {
	    FD_CLR(fd, &SET_0(device));
	}

	fd++;
	if (fd == NFDS(device)) {
	    _Mylene101_deck_e101(device);
	}
    }

    return status;
}
