/*
 * e101-mv.g.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e101-access.h>
#include <e101-defs.h>
#include <e101-names.h>
#include <e101-types.h>

static int pick_case(struct clause_type *, int, int, void **);

static int
pick_case(struct clause_type *clause_data, int fd, int df, void **pick)
{
    int delete = 0;

    do {
	if (clause_data->fd == fd) {
	    if ((clause_data->bits ^ df) & CLAUSE_OUTPUT) {
	    } else {
		*pick = clause_data;
		if (1) {
		    delete = 1;
		    if (1) {
			break;
		    }
		}
	    }
	}

	clause_data = clause_data->post_clause;
    } while (clause_data);

    return delete;
}


int
_Mylene101_pick_case(void *device, int fd, int df, void **pick)
{
    int delete;

    do {
	struct clause_type *clause_data;

	clause_data = CLAUSE(device);
	if (clause_data) {
	    delete = pick_case(clause_data, fd, df, pick);
	    if (delete) {
		break;
	    }
	}

	clause_data = PERIOD(device);
	if (clause_data) {
	    delete = pick_case(clause_data, fd, df, pick);
	    if (delete) {
		break;
	    }
	}
    } while (0);

    return delete;
}
