/*
 * e101-mv.f.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfset.h>
#include <e101-access.h>
#include <e101-errors.h>
#include <e101-inter.h>
#include <e101-names.h>
#include <e101-types.h>

int
_Mylene101_link_fair(void *device, void *reflex, void *effect)
{
    int excess, (*fini) (void *, void *), status;
    struct agenda_type *agenda_data;
    struct effect_type *effect_data;

    effect_data = effect;

    agenda_data = effect_data->agenda_data;

    EXTENT(device)--;

    status = x1f4_mind_bqfset(ESET(device));
    if (status) {
	status = _Mylene101_stat_free(device);
    } else {
	status = agenda_data->fare(reflex, agenda_data->text);
	if (status) {
	    EXCESS(device) = status;
	    status = FARE_ERROR;
	}
    }

    fini = agenda_data->fini;
    if (fini) {
	excess = fini(reflex, agenda_data->text);
	if (excess) {
	    if (status) {
	    } else {
		EXCESS(device) = excess;
		status = FINI_ERROR;
	    }
	}
    }

    excess = LINK_M(device).free(LINK_M(device).data, agenda_data);
    if (excess) {
	if (status) {
	} else {
	    status = _Mylene101_stat_free(device);
	}
    }

    return status;
}
