/*
 * e101-me.0.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e101-access.h>
#include <e101-errors.h>
#include <e101-names.h>

int
_Mylene101_stat_busy(void *device)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = LINK_E(device).data;

	line = LINK_E(device).line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = LINK_E(device).push;
	if (push) {
	    status = push(data, "dispatching already", 19);
	    if (status) {
		break;
	    }
	}

	post = LINK_E(device).post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return BUSY_ERROR;
}


int
_Mylene101_stat_free(void *device)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = LINK_E(device).data;

	line = LINK_E(device).line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = LINK_E(device).push;
	if (push) {
	    status = push(data, "cannot free memory", 18);
	    if (status) {
		break;
	    }
	}

	post = LINK_E(device).post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return FREE_ERROR;
}


int
_Mylene101_stat_link(void *device)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = LINK_E(device).data;

	line = LINK_E(device).line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = LINK_E(device).push;
	if (push) {
	    status = push(data, "cannot allocate memory", 22);
	    if (status) {
		break;
	    }
	}

	post = LINK_E(device).post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return LINK_ERROR;
}


int
_Mylene101_stat_poll(void *device, int error)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = LINK_E(device).data;

	line = LINK_E(device).line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = LINK_E(device).push;
	if (push) {
	    status = push(data, "cannot select: ", 15);
	    if (status) {
		break;
	    } else {
		const char *string;

		string = strerror(error);
		status = push(data, string, strlen(string));
		if (status) {
		    break;
		} else {
		    status = push(data, "\n", 1);
		    if (status) {
			break;
		    }
		}
	    }
	}

	post = LINK_E(device).post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return POLL_ERROR;
}
