/*
 * e101-mv.8.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e101-access.h>
#include <e101-names.h>
#include <e101-types.h>

static int deck_e101(struct clause_type *, int *);

static int
deck_e101(struct clause_type *clause_data, int *nfds)
{
    int fds;

    fds = *nfds;
    do {
	int fd;

	fd = clause_data->fd;
	if (fd < fds) {
	} else {
	    fds = fd + 1;
	}

	clause_data = clause_data->post_clause;
    } while (clause_data);

    *nfds = fds;

    return 0;
}


int
_Mylene101_deck_e101(void *device)
{
    int nfds = 0;
    struct clause_type *clause_data;

    clause_data = CLAUSE(device);
    if (clause_data) {
	deck_e101(clause_data, &nfds);
    }

    clause_data = PERIOD(device);
    if (clause_data) {
	deck_e101(clause_data, &nfds);
    }

    NFDS(device) = nfds;

    return 0;
}
