/*
 * e101-es.0.c
 * Copyright (C) 2002-2011, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <string.h>

#include <sys/time.h>

#include <bqfset.h>
#include <e101-access.h>
#include <e101-names.h>
#include <e101-types.h>

#define __UNROLL_PICK__			0

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#if SIZEOF_VOID_P == 8
# define HALF				040
#else
# define HALF				020
#endif				/* SIZEOF_VOID_P == 8 */

#define SECOND_A(___v)			((___v)->effect.tv_sec)
#define SECOND_F(___v)			((___v)->effect.tv_usec)

#define SECOND_a(___v)			SECOND_A((struct effect_type *) (___v))
#define SECOND_f(___v)			SECOND_F((struct effect_type *) (___v))

static int fine_fare(void *, void *);
static int fine_look(void *, void *, unsigned *);
static int fine_move(void *, void *, unsigned);
static int fine_pick(void *, void *, unsigned *);

static int
fine_fare(void *text, void *node)
{
    int c;
    time_t u, v;

    u = SECOND_a(text);
    v = SECOND_a(node);

    if (u ^ v) {
	c = u < v ? -1 : 1;
    } else {
	unsigned p, q;

	p = SECOND_f(text);
	q = SECOND_f(node);

	c = p < q ? -1 : 1;
    }

    return c;
}


static int
fine_look(void *text, void *node, unsigned *pick)
{
    unsigned size;

    size = *(integral_q *) node;
    if (size) {
	struct effect_type *effect_call;
	time_t u, v;
	unsigned p, q;

	u = SECOND_a(text);
	p = SECOND_f(text);

	effect_call = node;
	effect_call++;

	while (size ^ 1) {
	    struct effect_type *effect_slip;
	    unsigned half;

	    half = size >> 1;
	    effect_slip = effect_call + half;

	    v = SECOND_A(effect_slip);
	    if (u ^ v) {
		if (u < v) {
		    size = half;
		} else {
		    effect_call = effect_slip;
		    size -= half;
		}
	    } else {
		q = SECOND_F(effect_slip);
		if (p < q) {
		    size = half;
		} else {
		    effect_call = effect_slip;
		    size -= half;
		}
	    }
	}

	v = SECOND_A(effect_call);
	if (u ^ v) {
	    if (u < v) {
		effect_call--;
	    } else {
	    }
	} else {
	    q = SECOND_F(effect_call);
	    if (p ^ q) {
		if (p < q) {
		    effect_call--;
		} else {
		}
	    } else {
	    }
	}

	*pick = effect_call - (struct effect_type *) node;
    } else {
	*pick = 0;
    }

    return 0;
}


static int
fine_move(void *target, void *source, unsigned count)
{
    memmove(target, source, count * sizeof(struct effect_type));

    return 0;
}


static int
fine_pick(void *text, void *node, unsigned *pick)
{
    struct effect_type *effect_call;
    time_t u, v;
    unsigned half = HALF, p, q, slip = 0;

    u = SECOND_a(text);
    p = SECOND_f(text);

    effect_call = node;

    do {
	struct effect_type *effect_slip;

	effect_slip = effect_call + slip + half;
	v = SECOND_A(effect_slip);
	if (u ^ v) {
	    if (u < v) {
	    } else {
		slip += half;
	    }
	} else {
	    q = SECOND_F(effect_slip);
	    if (p < q) {
	    } else {
		slip += half;
	    }
	}

	half >>= 1;
    } while (half ^ 1);

    if (*(integral_q *) node & (integral_q) 2 << slip) {
	effect_call += slip + 1;
	v = SECOND_A(effect_call);
	if (u ^ v) {
	    if (u < v) {
	    } else {
		slip++;
	    }
	} else {
	    q = SECOND_F(effect_call);
	    if (p < q) {
	    } else {
		slip++;
	    }
	}

	*pick = slip;
    } else {
	*pick = slip + 1;
    }

    return 0;
}


int
_Mylene101_init_eset(void *device)
{
    struct x1f4_bqfset_type bqfset;

    bqfset.size = sizeof(struct effect_type);

    bqfset.fare = fine_fare;
    bqfset.look = fine_look;
    bqfset.move = fine_move;
    bqfset.pick = fine_pick;

    bqfset.trans = &LINK_M(device);

    return x1f4_init_bqfset
	(&ESET(device), X1f4_BQFSET_SIZE_FRAME | X1f4_BQFSET_TRANS_MASK,
	 &bqfset);
}
