/*
 * e101-access.h
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __Mylene101_access_H__
#define __Mylene101_access_H__

#include <e101-state.h>

#define CLAUSE(device)			ACCESS((device), clause_data)
#define COURSE(device)			ACCESS((device), clause_slip)
#define EFFECT(device)			ACCESS((device), effect_data)
#define ESET(device)			ACCESS((device), eset)
#define EXCESS(device)			ACCESS((device), excess)
#define EXTENT(device)			ACCESS((device), extent)
#define LINK_E(device)			ACCESS((device), weekly.link_e)
#define LINK_M(device)			ACCESS((device), link_m)
#define METHOD(device)			ACCESS((device), method_data)
#define NFDS(device)			ACCESS((device), nfds)
#define PERIOD(device)			ACCESS((device), clause_long)
#define SET_0(device)			ACCESS((device), set_0)
#define SET_1(device)			ACCESS((device), set_1)
#define SCHEDULED(device)		ACCESS((device), scheduled)
#define STATES(device)			ACCESS((device), states)
#define TICKET(device)			ACCESS((device), method_slip)

#define ACCESS(device, member)		(SERVER(device)->member)

#define SERVER(device)			((struct device_state *) (device))

#define SCHEDULED_EXTENT(device)	(SCHEDULED(device) & EXTENT(device))

#endif				/* __Mylene101_access_H__ */
