/*
 * dlxx.o.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <dlxx-defs.h>
#include <dlxx-names.h>
#include <dlxx-types.h>

#define dllist(dllist)			((struct dllist_type *) (dllist))

static int copy_node(struct dllist_type *, struct fpnode_type **,
		     struct fpnode_type *, struct fpnode_type *,
		     int (*) (void *, void *, const void *),
		     int (*) (void *, void *), void *, unsigned, unsigned,
		     unsigned);
static int free_node(struct dllist_type *, struct fpnode_type *,
		     int (*) (void *, void *), void *, unsigned, unsigned);

static int
copy_node(struct dllist_type *dllist_data, struct fpnode_type **fpnode,
	  struct fpnode_type *fpnode_data, struct fpnode_type *fpnode_slip,
	  int (*copy) (void *, void *, const void *),
	  int (*free) (void *, void *), void *context, unsigned slip,
	  unsigned item, unsigned node)
{
    int status;

    while (1) {
	void *dlnode;

	status = dllist_data->link_m.link
	    (dllist_data->link_m.data, &dlnode, node);
	if (status) {
	    free_node(dllist_data, fpnode[0], free, context, slip, item);

	    status = LINK_ERROR;

	    break;
	} else {
	    struct fpnode_type *fpnode_copy;
	    unsigned text;
	    void *data, *fast;

	    fpnode_copy = dlnode;

	    text = fpnode_data->pick;

	    fpnode_copy->pick = text;

	    text *= item;
	    text += slip;

	    data = (char *) fpnode_data + text;
	    fast = (char *) dlnode + text;

	    text = fpnode_data->text;

	    fpnode_copy->text = text;

	    for (; text; text--) {
		status = copy(context, fast, data);
		if (status) {
		    break;
		} else {
		    data = (char *) data + item;
		    fast = (char *) fast + item;
		}
	    }

	    if (text) {
		fpnode_copy->text -= text;

		free_node(dllist_data, fpnode_copy, free, context, slip, item);

		status = LINK_ERROR;

		break;
	    } else {
		fpnode[1] = fpnode_copy;

		fpnode_copy->fpnode_data[0] = fpnode_slip;

		fpnode_data = fpnode_data->fpnode_data[1];

		if (fpnode_data) {
		    fpnode = fpnode_copy->fpnode_data;

		    fpnode_slip = fpnode_copy;
		} else {
		    fpnode_copy->fpnode_data[1] = NULL;

		    dllist_data->link_a.fplist.fplink.fpnode_data[0] =
			fpnode_copy;

		    break;
		}
	    }
	}
    }

    return status;
}


static int
free_node(struct dllist_type *dllist_data, struct fpnode_type *fpnode_data,
	  int (*free) (void *, void *), void *context, unsigned slip,
	  unsigned item)
{
    while (fpnode_data) {
	unsigned text;
	void *fast;

	fast = (char *) fpnode_data + slip + fpnode_data->pick * item;

	text = fpnode_data->text;

	for (; text; text--) {
	    free(context, fast);
	    if (1) {
		fast = (char *) fast + item;
	    }
	}

	if (1) {
	    struct fpnode_type *fpnode_link;

	    fpnode_link = fpnode_data;

	    fpnode_data = fpnode_data->fpnode_data[0];

	    dllist_data->link_m.free(dllist_data->link_m.data, fpnode_link);
	}
    }

    return -1;
}


int
_libx1f4l2_rail_dllist(void *dldata, void *dltext,
		       int (*copy) (void *, void *, const void *),
		       int (*free) (void *, void *), void *context)
{
    int status;

    dllist(dldata)->link_a.fplist.fplink.fpnode_data[0] = NULL;

    status = copy_node
	(dldata, dllist(dldata)->link_a.fplist.fplink.fpnode_data,
	 dllist(dltext)->link_a.fplist.fplink.fpnode_data[1], NULL, copy, free,
	 context, dllist(dldata)->link_a.fplist.link_v.slip,
	 dllist(dldata)->link_a.fplist.link_v.item,
	 dllist(dldata)->link_a.fplist.link_v.node);
    if (status) {
    } else {
	dllist(dldata)->link_a.fplist.link_v.size =
	    dllist(dltext)->link_a.fplist.link_v.size;
    }

    return status;
}
