/*
 * dlxx.l.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <dlxx-defs.h>
#include <dlxx-names.h>
#include <dlxx-types.h>

#define dllist(dllist)			((struct dllist_type *) (dllist))

static int free_node(struct fpnode_type *, void *, void *,
		     int (*) (void *, void *));

static int
free_node(struct fpnode_type *fpnode_data, void *dllist, void *data,
	  int (*free) (void *, void *))
{
    int status;

    do {
	struct fpnode_type *fqnode_data;

	fqnode_data = fpnode_data->fpnode_data[1];

	if (1) {
	    status = free(data, fpnode_data);
	    if (status) {
		status = FREE_ERROR;

		fpnode_data->fpnode_data[0] = NULL;

		dllist(dllist)->link_a.fplist.fplink.fpnode_data[1] =
		    fpnode_data;

		break;
	    }
	}

	fpnode_data = fqnode_data;
    } while (fpnode_data);

    return status;
}


int
_libx1f4l2_ceil_dllist(void *dllist)
{
    int status;
    struct fpnode_type *fpnode_data;

    fpnode_data = dllist(dllist)->link_a.fplist.fplink.fpnode_data[1];
    if (fpnode_data) {
	status = free_node
	    (fpnode_data, dllist, dllist(dllist)->link_m.data,
	     dllist(dllist)->link_m.free);
    } else {
	status = 0;
    }

    return status;
}
