/*
 * dlxx.d.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <dlxx-defs.h>
#include <dlxx-inter.h>
#include <dlxx-names.h>
#include <dlxx-types.h>

#define dllist(dllist)			((struct dllist_type *) (dllist))

int
x1f4_line_dllist(void *dldata, void *dltext,
		 int (*copy) (void *, void *, const void *),
		 int (*free) (void *, void *), void *context)
{
    int status;

    if (dllist(dldata)->link_a.fplist.link_v.size) {
	status = SIZE_ERROR;
    } else {
	if (dllist(dltext)->link_a.fplist.link_v.size) {
	    status = _libx1f4l2_rail_dllist
		(dldata, dltext, copy, free, context);
	} else {
	    status = 0;
	}
    }

    return status;
}
