/*
 * dlxx.c.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <dlxx-defs.h>
#include <dlxx-inter.h>
#include <dlxx-names.h>
#include <dlxx-types.h>
#include <trans.h>

static int fini_list(void **);
static int init_list(void **, struct dllist_type *);
static int text_list(struct dllist_type *, struct dllist_type *,
		     int (*) (void *, void *, const void *),
		     int (*) (void *, void *), void *);

static int
fini_list(void **text)
{
    return _libx1f4l2_fini_dllist(text);
}


static int
init_list(void **text, struct dllist_type *dllist_data)
{
    int status;
    struct screen_type screen;
    struct trans_type trans;

    screen.item = dllist_data->link_a.fplist.link_v.item;
    screen.node = dllist_data->link_a.fplist.link_v.node;

    screen.trans_data = &trans;

    trans.data = dllist_data->link_m.data;
    trans.free = dllist_data->link_m.free;
    trans.link = dllist_data->link_m.link;
    trans.mode = dllist_data->link_m.mode;

    status = _libx1f4l2_init_dllist(text, TRANS_MASK, &screen);

    return status;
}


static int
text_list(struct dllist_type *dllist_data, struct dllist_type *dllist_text,
	  int (*copy) (void *, void *, const void *),
	  int (*free) (void *, void *), void *context)
{
    int status;

    if (dllist_text->link_a.fplist.link_v.size) {
	status = _libx1f4l2_rail_dllist
	    (dllist_data, dllist_text, copy, free, context);
    } else {
	status = 0;
    }

    return status;
}


int
x1f4_text_dllist(void **dllist, void *dltext,
		 int (*copy) (void *, void *, const void *),
		 int (*free) (void *, void *), void *context)
{
    int status;
    void *text;

    status = init_list(&text, dltext);
    if (status) {
    } else {
	status = text_list(text, dltext, copy, free, context);
	if (status) {
	    fini_list(&text);
	} else {
	    *dllist = text;
	}
    }

    return status;
}
