/*
 * dlxx.0.c
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>

#include <dlxx-defs.h>
#include <dlxx-inter.h>
#include <dlxx-names.h>
#include <dlxx-types.h>
#include <mask.0.h>
#include <trans.h>

int
x1f4_init_dllist(void **dllist, unsigned flags,
		 struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *text;

    if (flags & TRANS_MASK) {
	struct trans_type *trans_data;

	trans_data = screen_data->trans_data;

	link = trans_data->link;
	text = trans_data->data;
    } else {
	link = _libx1f4l2_link_data;
	text = (void *) 0;
    }

    status = link(text, &text, sizeof(struct dllist_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	struct dllist_type *dllist_data;

	dllist_data = text;

	status = _libx1f4l2_fast_dllist(dllist_data, flags, screen_data);

	if (status) {
	    int (*free) (void *, void *);

	    if (flags & TRANS_MASK) {
		struct trans_type *trans_data;

		trans_data = screen_data->trans_data;

		free = trans_data->free;
		text = trans_data->data;
	    } else {
		free = _libx1f4l2_free_data;
	    }

	    free(text, dllist_data);
	} else {
	    *dllist = text;
	}
    }

    return status;
}
