/*
 * dllist.h
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_DLLIST_H__
#define __LIBx1f4_DLLIST_H__

#include <dlxx-names.h>
#include <errors.h>

/*
 * attribute bit definitions
 */
#define X1f4_DLLIST_TRANS_MASK		(1u << 0x00)

/*
 * error definitions
 */
#define X1f4_DLLIST_CALL_ERROR		LIBx1f4L2_CALL_ERROR
#define X1f4_DLLIST_DECK_ERROR		LIBx1f4L2_DECK_ERROR
#define X1f4_DLLIST_FREE_ERROR		LIBx1f4L2_FREE_ERROR
#define X1f4_DLLIST_LINK_ERROR		LIBx1f4L2_LINK_ERROR
#define X1f4_DLLIST_MODE_ERROR		LIBx1f4L2_MODE_ERROR
#define X1f4_DLLIST_SIZE_ERROR		LIBx1f4L2_SIZE_ERROR
#define X1f4_DLLIST_TEXT_ERROR		LIBx1f4L2_TEXT_ERROR

typedef struct x1f4_dllist_type {
    unsigned item, node;
    void *trans;
} x1f4_dllist_type;

#if !defined __x1f4_trans_type_defined__
typedef struct x1f4_trans_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned);
    void *data;
} x1f4_trans_type;
#endif				/* !__x1f4_trans_type_defined__ */

#if !defined __x1f4_trans_type_defined__
# define __x1f4_trans_type_defined__
#endif				/* !__x1f4_trans_type_defined__ */

extern int x1f4_call_dllist(unsigned *);
extern int x1f4_ever_dllist(void *, void **);
extern int x1f4_fast_dllist(void *, unsigned, struct x1f4_dllist_type *);
extern int x1f4_fini_dllist(void **);
extern int x1f4_flat_dllist(void *);
extern int x1f4_head_dllist(void *, void **);
extern int x1f4_high_dllist(void *);
extern int x1f4_init_dllist(void **, unsigned, struct x1f4_dllist_type *);
extern int x1f4_lead_dllist(void *, void **);
extern int x1f4_lime_dllist(void *, void *, int (*) (void *, void *));
extern int x1f4_line_dllist
    (void *, void *, int (*) (void *, void *, const void *),
     int (*) (void *, void *), void *);
extern int x1f4_mind_dllist(void *);
extern int x1f4_reel_dllist(void *);
extern int x1f4_roll_dllist(void *);
extern int x1f4_size_dllist(void *, unsigned *);
extern int x1f4_slip_dllist(void *);
extern int x1f4_swap_dllist(void *, void *);
extern int x1f4_tail_dllist(void *, void **);
extern int x1f4_text_dllist
    (void **, void *, int (*) (void *, void *, const void *),
     int (*) (void *, void *), void *);

#endif				/* __LIBx1f4_DLLIST_H__ */
