/*
 * cstring.c
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>

#if !defined LIBx1f4i0
# include <cstring.f.h>
#endif				/* !LIBx1f4i0 */
#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */

#define C_TYPE_X(___c_type_x, ___c) \
    ((___c_type_x)[(___c) >> 5] & 1 << ((___c) & 31))

static const char escapes[] = "abtnvfr";
static const unsigned c_type_0[] = {
/*
 * . . . . . . .               . .
 * . . . . . . . . . . . . . . . .
 *
 *
 *
 *
 *
 *                               .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 * . . . . . . . . . . . . . . . .
 */
/* *INDENT-OFF* */
    0xffffc07f, 0x00000000, 0x00000000, 0x80000000,
    0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff
/* *INDENT-ON* */
}, c_type_1[] = {
/*
 *               . . . . . . .
 *
 *     "
 *
 *
 *                         \
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00003f80, 0x00000004, 0x10000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

int
x1f4_print_cstring(FILE *file, const char *name)
{
    int status = 0;
    unsigned byte, miss = ~0;

    byte = *(const unsigned char *) name;
    while (byte) {
	if (C_TYPE_X(c_type_0, byte)) {
	    if (~miss) {
		status = x1f4_flush_cstring(file, 0, &miss);
		if (status == EOF) {
		    break;
		}
	    }
	    if (byte < 64) {
		miss = byte;
	    } else {
		status = putc('\\', file);
		if (status == EOF) {
		    break;
		}
		status = putc(((byte >> 6) & 0x07) + 0x30, file);
		if (status == EOF) {
		    break;
		}
		status = putc(((byte >> 3) & 0x07) + 0x30, file);
		if (status == EOF) {
		    break;
		}
		status = putc(((byte >> 0) & 0x07) + 0x30, file);
		if (status == EOF) {
		    break;
		}
	    }
	} else {
	    if (~miss) {
		status = x1f4_flush_cstring
		    (file, 0x2f < byte && byte < 0x38, &miss);
		if (status == EOF) {
		    break;
		}
	    }
	    if (C_TYPE_X(c_type_1, byte)) {
		status = putc('\\', file);
		if (status == EOF) {
		    break;
		}
		if (byte == 0x22) {
		    status = putc('"', file);
		    if (status == EOF) {
			break;
		    }
		} else {
		    if (byte == 0x5c) {
			status = putc('\\', file);
			if (status == EOF) {
			    break;
			}
		    } else {
			status = putc(escapes[byte - 0x07], file);
			if (status == EOF) {
			    break;
			}
		    }
		}
	    } else {
		status = putc(byte, file);
		if (status == EOF) {
		    break;
		}
	    }
	}

	name++;
	byte = *(const unsigned char *) name;
    }
    if (~miss) {
	if (1) {
	    if (status != EOF) {
		status = x1f4_flush_cstring(file, 0, &miss);
	    }
	}
    }

    return status != EOF ? 0 : -1;
}
