/*
 * cards3.c
 * Copyright (C) 2002-2011, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

int
x1f4_match_cards3(const char *major, unsigned major_length, const char *minor,
		  unsigned minor_length)
{
    for (; major_length; major_length--) {
	int c;

	c = *(const unsigned char *) major;
	if (c == '*') {
	    do {
		major++;
		major_length--;
	    } while (*major == '*' && major_length);
	    if (!major_length) {
		return 0;
	    } else {
		if (!minor_length) {
		    return -1;
		} else {
		    while (minor_length) {
			if (!x1f4_match_cards3
			    (major, major_length, minor, minor_length)) {
			    return 0;
			}
			minor++;
			minor_length--;
		    }

		    return 1;
		}
	    }
	} else if (c == '?') {
	    if (!minor_length) {
		return -1;
	    }
	    major++;
	    minor++;
	    minor_length--;
	} else {
	    if (!minor_length) {
		return -1;
	    }
	    if (c == '\\') {
		major++;
		major_length--;
		c = *(const unsigned char *) major;
		if (!c) {
		    return (unsigned) ~0 >> 1;
		}
	    }
	    if (c == *(const unsigned char *) minor) {
		major++;
		minor++;
		minor_length--;
	    } else {
		return 1;
	    }
	}
    }

    return minor_length;
}
