/*
 * c12nd.0.c
 * Copyright (C) 2006-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1-inter.h>
#include <c1-types.h>
#include <e4.h>

int
x1f4_lead_program(struct c1_program_type *program_data, void **used)
{
    int status = 0;
    struct c1_node_type *node_data;

    node_data = program_data->node;
    if (node_data) {
	void *miss, **copy;

	copy = &program_data->slip;

	miss = (char *) used + program_data->post;

	do {
	    void *data;

	    *copy = node_data;

	    data = node_data->data.data;
	    if (data) {
		status = x1f4_last_expression(data, miss, used);
		if (status) {
		    if (1) {
			break;
		    }
		} else {
		    node_data = node_data->node_data;
		}
	    } else {
		data = (node_data + 1)->data.data;

		if (!data) {
		    node_data++;
		    node_data = node_data->node_data;
		} else {
		    int deck;

		    status = x1f4_cast_expression(data, &deck, miss, used);
		    if (status) {
			if (1) {
			    break;
			}
		    } else {
			if (deck) {
			    node_data = node_data->node_data;
			} else {
			    node_data++;
			    node_data = node_data->node_data->node_data;
			}
		    }
		}
	    }
	} while (node_data);
    }

    return status;
}
