/*
 * c1.v.c
 * Copyright (C) 2010-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1-types.h>
#include <e4.h>
#include <lxcast.h>

#define I_USER(i)			(*((X1f4_E4_C_USER *) (i)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

typedef struct upcast_type {
    struct x1f4_dxcast_type dxcast;
    void *text;
} upcast_type;

static int slip_object(void *);

static int
slip_object(void *upcast)
{
    struct upcast_type *upcast_data;
    void *dxcast;

    upcast_data = upcast;

    dxcast = &upcast_data->dxcast;

    return x1f4_slip_lxcast(upcast_data->text, &dxcast);
}


int
_x1f4_c1_post_cast(void *program, void *context, void *post)
{
    int status;
    void *data, **mind;

    status = ((struct c1_program_type *) program)->v.f.pick
	(((struct c1_program_type *) program)->u.data, &mind, slip_object,
	 sizeof(struct upcast_type), &data);
    if (status) {
    } else {
	struct upcast_type *upcast_data;
	struct x1f4_dxcast_type *dxcast_data;
	void *text;

	*mind = data;

	text = (void *) ((struct c1_program_type *) program)->v.f.text;

	upcast_data = data;

	upcast_data->text = text;

	dxcast_data = &upcast_data->dxcast;

	*dxcast_data = *(struct x1f4_dxcast_type *) I_USER(post);

	dxcast_data->call = 0;

	status = x1f4_lead_lxcast(text, (void *) &dxcast_data);
	if (status) {
	    dxcast_data->type = X1f4_E4_MODE;
	}

	l_USER(dxcast_data, post);
    }

    return status;
}
