/*
 * c1.s.c
 * Copyright (C) 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <e4fine.h>
#include <c1-types.h>

extern const char *const x1f4_c1_empty_string;

int
x1f4_pull_program(void *program, void *pull)
{
    int status = 0;
    struct c1_miss_type *miss_data;

    miss_data = ((struct c1_program_type *) program)->miss;
    while (miss_data) {
	struct x1f4_variable_type *variable_data;

	variable_data = miss_data->data;
	if (variable_data->flags & X1f4_E4_UNIVERSAL) {
	    int type;
	    void *link;

	    link = (char *) pull + (int) miss_data->link;

	    type = variable_data->type;
	    if (type == X1f4_E4_TEXT) {
		const X1f4_E4_C_TEXT *text;

		text = link;
		*text = x1f4_c1_empty_string;
	    } else {
		if (type < X1f4_E4_LAST) {
		} else {
		    const X1f4_E4_C_USER *user;

		    user = link;
		    if (type < X1f4_E4_CALL) {
			int (*link) (void *, void **);
			const struct c1_type_type *cell_type;

			cell_type = miss_data->type;

			link = cell_type->link;
			if (link) {
			    void *cell;

			    status = link(cell_type->context, &cell);
			    if (status) {
				break;
			    } else {
				*user = cell;
			    }
			}
		    } else {
			{
			    const struct x1f4_linetext_type *linetext_data;

			    /*
			     * TODO
			     *
			     * the call may be eliminated by
			     * retrieving the function definition
			     * with the preceding e4jack call
			     */
			    x1f4_pick_e4fine
				(((struct c1_program_type *) program)->high,
				 type, &linetext_data);
			    *user = (void *) linetext_data;
			}
		    }
		}
	    }
	}

	miss_data = miss_data->last_miss;
    }

    return status;
}
