/*
 * c1.p.c
 * Copyright (C) 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1-inter.h>
#include <c1-types.h>

int
_x1f4_c1_link_mine(struct c1_program_type *program_data, void **link)
{
    int status;

    status = program_data->m.link
	(program_data->m.data, link, program_data->used);
    if (status) {
	status = _x1f4_c1_stat_link(program_data);
    } else {
	status = x1f4_pull_program(program_data, *link);
	if (status) {
	    program_data->m.free(program_data->m.data, *link);
	}
    }

    return status;
}
