/*
 * c1.n.c
 * Copyright (C) 2010-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <af.h>
#include <c1-types.h>
#include <dt.h>
#include <e4.h>

typedef struct upcast_type {
    void *call;
} upcast_type;

static int slip_object(void *);

static int
slip_object(void *upcast)
{
    int status;
    struct upcast_type *upcast_data;
    void *call;

    upcast_data = upcast;

    call = upcast_data->call;
    if (call) {
	status = _x1f4_slip_effect(NULL, &call);
    } else {
	status = 0;
    }

    return status;
}


int
_x1f4_c1_post_call(void *program, void *context, void *post)
{
    int status;
    void *data, **mind;

    status = ((struct c1_program_type *) program)->v.f.pick
	(((struct c1_program_type *) program)->u.data, &mind, slip_object,
	 sizeof(struct upcast_type), &data);
    if (status) {
    } else {
	struct upcast_type *upcast_data;

	*mind = data;

	upcast_data = data;

	status = _x1f4_lead_effect(NULL, post);
	if (status) {
	    upcast_data->call = NULL;
	} else {
	    upcast_data->call = *(void **) post;
	}
    }

    return status;
}
