/*
 * c1.7.c
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TODO
 *
 *.remove unused variables
 *.there seem to be a lot of useless checks for zero byte around, remove maybe
 *.see whether do { ...; break; ... } while (0) may be improved.  If code is
 * inserted for the _while (0)_ or unlikely for the _do_, the code may be
 * missed.
 */
/*
 * FEATURES
 *
 *.second _c1_node_type_ record in double allocations is left with its _state_
 * field unset
 *.when copying the variable tree the memory manager of the source (tree) is
 * used.  the parsing memory manager should be used instead.
 *.the (net_tree) look and replace or insert sequence should be performed in a
 * single mx/s5 operation - same for a1
 */

#include <config.h>

#include <c1-config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stddef.h>
#include <string.h>

#if !defined HAVE_LIBx1f4i0
# include <akeylook-l.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <c1-defs.h>
#include <c1-inter.h>
#include <c1-parse.h>
#include <c1-types.h>
#if !defined HAVE_LIBx1f4i0
# include <ckeyhead.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <ctype.0.h>
#include <e4-m.0.h>
#include <e4.h>
#include <e4fine.h>
#include <e4jack.h>
#include <mxdeck.h>
#include <trans.h>

#define __DEBUG_MISS__			0
#define __DEBUG_RACK__			0

#if 0
# define __D_DEBUG__			0
#elif __DEBUG_MISS__
# define __D_DEBUG__			1
#elif __DEBUG_RACK__
# define __D_DEBUG__			1
#else
# define __D_DEBUG__			0
#endif				/* 0 */

#define CASE_BILL			1
#define CASE_MODE			2
#define CASE_REAL			3
#define CASE_TEXT			4

#define CASE_VOID			5

#define HALF_CASE			6

#define CASE_LOOP			6
#define CASE_POST			7
#define CASE_RACK			8
#define CASE_TEST			9

#define CASE_TURN			10

#define BACK_CASE			11
#define HEAD_CASE			12

#define TYPE_CASE			13

#define LAST_CASE			14

#define ELSE_CASE			15

#define true(e)				1

#define PROGRAM(program) \
    ((c1_program_type *) program)

#if __D_DEBUG__
# define ddebug_head(type, miss) \
    ddebug_3("/*--%s%.*s\n", (type), 60 - (miss), \
	     "--------------------------------------------------------------" \
	     "--")
#endif				/* __D_DEBUG__ */

#if __D_DEBUG__
# define ddebug_tail() \
    ddebug_0("  " "------------------------------------*/\n")
#endif				/* __D_DEBUG__ */

#if __D_DEBUG__
# include <stdio.h>
#endif				/* __D_DEBUG__ */

#if __D_DEBUG__
# define ddebug_0(format) \
    fprintf(stderr, format)
# define ddebug_1(format, a) \
    fprintf(stderr, format, a)
# define ddebug_2(format, a, b) \
    fprintf(stderr, format, a, b)
# define ddebug_3(format, a, b, c) \
    fprintf(stderr, format, a, b, c)
#endif				/* __D_DEBUG__ */

#define E_FREE(mcontext, mdata) \
    (PROGRAM(mcontext)->m.free(PROGRAM(mcontext)->m.data, (mdata)))
#define E_LINK(mcontext, mdata, size) \
    (PROGRAM(mcontext)->m.link						      \
	(PROGRAM(mcontext)->m.data, (void *) (mdata), (size)))
#define E_MODE(mcontext, mdata, size) \
    (PROGRAM(mcontext)->m.mode						      \
	(PROGRAM(mcontext)->m.data, (void *) (mdata), (size)))

#define M_FREE(mcontext, mdata) \
    (mcontext)->m.free((mcontext)->m.data, (mdata))
#define M_LINK(mcontext, mdata, size) \
    (mcontext)->m.link((mcontext)->m.data, (void *) (mdata), (size))
#define M_MODE(mcontext, mdata, size) \
    (mcontext)->m.mode((mcontext)->m.data, (void *) (mdata), (size))

#define line_copy(parser_data) \
    (((parser_data)->program - (parser_data)->thirteen) & LINE_COPY)

typedef struct half_type {
    struct trans_type *trans_data;
    void *variable_slip;
} half_type;

typedef struct slip_type {
    int level;
    struct c1_miss_type *miss_data;
    struct c1_node_type *node_data;
    struct slip_type *last_slip;
    unsigned count, trail;
    void *data;
} slip_type;

extern const char *const x1f4_c1_empty_string;

extern const struct x1f4_akeytree_type _x1f4_c1_text_root[];

extern const struct x1f4_datatype_type _x1f4_af_last_type;

static int air_ceil(struct parser_type *, struct slip_type *,
		    struct slip_type *);
static int air_miss(struct parser_type *);
static int air_nets(struct parser_type *);
static int air_post(struct parser_type *);
static int air_raCk(struct parser_type *, unsigned *);
static int air_rack(struct parser_type *, unsigned *);
static int air_slip(struct parser_type *, unsigned *);
static int air_ways(struct parser_type *);
static int fit_miss(struct parser_type *);
#if 0
static int fit_post(struct parser_type *);
#endif				/* 0 */
static int fit_slip(struct parser_type *, int, struct c1_program_type *);
static int fix_aiLe(struct parser_type *);
static int fix_aiMe(struct parser_type *, int);
static int fix_aile(struct parser_type *);
static int fix_aime(struct parser_type *, int);
static int fix_back(struct parser_type *);
static int fix_bill(struct parser_type *);
static int fix_case(struct parser_type *, int);
static int fix_cell(struct parser_type *);
static int fix_data(struct parser_type *, const char *, unsigned, int);
static int fix_fast(struct parser_type *);
static int fix_half(struct parser_type *, struct hook_type *);
static int fix_heAd(struct parser_type *);
static int fix_head(struct parser_type *);
static int fix_laSt(struct parser_type *);
static int fix_last(struct parser_type *);
static int fix_loop(struct parser_type *);
static int fix_mode(struct parser_type *);
static int fix_node(struct parser_type *, void *);
static int fix_post(struct parser_type *);
static int fix_rack(struct parser_type *);
static int fix_real(struct parser_type *);
static int fix_side(struct parser_type *);
static int fix_test(struct parser_type *);
static int fix_text(struct parser_type *);
static int fix_turn(struct parser_type *);
static int fix_type(struct parser_type *, int, int);
static int fix_void(struct parser_type *);
static int get_line(unsigned *, struct parser_type *);
static int get_type(const char **, const void **, const struct c1_type_type *);
static int ink_back(struct parser_type *);
static int ink_byte(struct parser_type *);
static int ink_data(struct parser_type *);
static int ink_fine(struct parser_type *);
static int ink_node(struct parser_type *, struct c1_node_type **, unsigned);
static int ink_turn(struct parser_type *);
static int extend_state(struct parser_type *);
static int map_data(struct parser_type *);
static int map_zero(struct parser_type *, const struct c1_context_type *);
static int max_data(struct parser_type *);
static int net_data(struct parser_type *);
static int net_tree(void *, const void *, const char *, unsigned);
static int set_clip(struct parser_type *, struct hook_type *);
static int set_data(struct parser_type *);
static int set_ever(struct parser_type *, struct hook_type *);
static int set_hook(struct parser_type *, struct hook_type *);
static int set_loop(struct parser_type *, struct hook_type *);
static int set_none(struct parser_type *, struct hook_type *);
static int set_post(struct parser_type *, struct hook_type *);
static int set_test(struct parser_type *, struct hook_type *);

static void air_fix(struct parser_type *);
static void air_mae(struct c1_node_type *, int (*) (void *, void *), void *);
static void air_set(struct c1_miss_type *, unsigned, int (*) (void *, void *),
		    void *);
static void fix_day(struct parser_type *, struct slip_type *);
static void fix_set(struct parser_type *);
static void net_red(struct parser_type *);
static void set_fix(struct parser_type *, unsigned);
static void way_far(const char **);
static void way_new(const char **);
static void way_red(const char **);

static const char end_class[] = "      ({;(";
static int (*const set_class[]) (struct parser_type *) = {
/* *INDENT-OFF* */
    NULL,
    fix_bill,
    fix_mode,
    fix_real,
    fix_text,
    fix_void,
    fix_loop,
    fix_post,
    fix_rack,
    fix_test,
    fix_turn,
    fix_back,
    fix_heAd,
    fix_cell,
    fix_laSt
/* *INDENT-ON* */
};
static const struct x1f4_ckeytree_type line_2[] = {
/* *INDENT-OFF* */
    {	"f",		{	CASE_TEST	},	NULL	},
    {	"nteger",	{	CASE_MODE	},	NULL	},
    {	NULL,		{	0		},	NULL	}
/* *INDENT-ON* */
}, line_1[] = {
/* *INDENT-OFF* */
    {	"al",		{	CASE_REAL	},	NULL	},
    {	"turn",		{	CASE_TURN	},	NULL	},
    {	NULL,		{	0		},	NULL	}
/* *INDENT-ON* */
}, line_0[] = {
/* *INDENT-OFF* */
    {	"break",	{	CASE_RACK	},	NULL	},
    {	"cardinal",	{	CASE_BILL	},	NULL	},
    {	"do",		{	CASE_POST	},	NULL	},
    {	"i",		{	0		},	line_2	},
    {	"re",		{	0		},	line_1	},
    {	"text",		{	CASE_TEXT	},	NULL	},
    {	"void",		{	CASE_VOID	},	NULL	},
    {	"while",	{	CASE_LOOP	},	NULL	},
    {	NULL,		{	0		},	NULL	}
/* *INDENT-ON* */
}, line_root[] = {
/* *INDENT-OFF* */
    {	"",		{	0		},	line_0	},
    {	NULL,		{	0		},	NULL	}
/* *INDENT-ON* */
}, lock_0[] = {
/* *INDENT-OFF* */
    {	"break",	{	CASE_RACK	},	NULL	},
    {	"do",		{	CASE_POST	},	NULL	},
    {	"if",		{	CASE_TEST	},	NULL	},
    {	"return",	{	CASE_TURN	},	NULL	},
    {	"while",	{	CASE_LOOP	},	NULL	},
    {	NULL,		{	0		},	NULL	}
/* *INDENT-ON* */
}, lock_root[] = {
/* *INDENT-OFF* */
    {	"",		{	0		},	lock_0	},
    {	NULL,		{	0		},	NULL	}
/* *INDENT-ON* */
};
static const unsigned c_type_1[] = {
/*
 *
 *
 *
 *
 *   A B C D E F G H I J K L M N O
 * P Q R S T U V W X Y Z         _
 *   a b c d e f g h i j k l m n o
 * p q r s t u v w x y z
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x00000000, 0x87fffffe, 0x07fffffe,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_2[] = {
/*
 *
 *
 *
 * 0 1 2 3 4 5 6 7 8 9
 *   A B C D E F G H I J K L M N O
 * P Q R S T U V W X Y Z         _
 *   a b c d e f g h i j k l m n o
 * p q r s t u v w x y z
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x03ff0000, 0x87fffffe, 0x07fffffe,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_4[] = {
/*
 *                   . .     .
 *
 * .
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00002600, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

static int
air_ceil(struct parser_type *parser_data, struct slip_type *last_slip,
	 struct slip_type *slip_data)
{
    int status = 0;

    do {
	if (!last_slip) {
	    if (parser_data->class & 1) {
		status = _x1f4_c1_fit_class
		    (parser_data, slip_data->count, slip_data->miss_data,
		     slip_data->node_data);
		if (status) {
		    break;
		}
	    }
	    if (parser_data->class & 2) {
		status = _x1f4_c1_fit_sweep
		    (parser_data, slip_data->count, slip_data->miss_data);
	    }
	} else {
	    if (parser_data->class & 1) {
		status = _x1f4_c1_fit_class
		    (parser_data, slip_data->count - last_slip->trail,
		     slip_data->miss_data, slip_data->node_data);
		if (status) {
		    break;
		}
	    }
	    if (parser_data->class & 2) {
		status = _x1f4_c1_fit_sweep
		    (parser_data, slip_data->count - last_slip->trail,
		     slip_data->miss_data);
		if (status) {
		    break;
		}
	    }
	    if (1) {
		if (0) {
		} else {
		    last_slip->trail = parser_data->count;
		}
	    }
	}
    } while (0);

    return status;
}


static int
air_miss(struct parser_type *parser_data)
{
    int status = 0;
    struct slip_type *last_slip;

    last_slip = parser_data->slip_data;
    if (!last_slip) {
#if 1
	set_fix(parser_data, parser_data->count);
#else
	if (parser_data->class & 2) {
	    status = _x1f4_c1_fit_sweep
		(parser_data, parser_data->count, parser_data->miss_data);
	}
#endif				/* 1 */
    } else {
#if 1
	set_fix(parser_data, parser_data->count - last_slip->trail);
#else
	if (parser_data->class & 2) {
	    status = _x1f4_c1_fit_sweep
		(parser_data, parser_data->count - last_slip->trail,
		 parser_data->miss_data);
	    if (status) {
	    } else {
		last_slip->trail = parser_data->count;
	    }
	} else {
	    if (1) {
		last_slip->trail = parser_data->count;
	    }
	}
#endif				/* 1 */
    }

    return status;
}


static int
air_nets(struct parser_type *parser_data)
{
    int status;
    struct slip_type *last_slip;

    last_slip = parser_data->slip_data;
    if (!last_slip) {
	status = 0;
    } else {
	if (last_slip->level != parser_data->level) {
	    status = 0;
	} else {
	    struct slip_type *slip_data;

	    slip_data = last_slip->last_slip;
	    if (slip_data) {
		parser_data->attributes.variable_set.context = slip_data->data;
	    } else {
		parser_data->attributes.variable_set.context =
		    parser_data->variable_deck;
	    }

	    parser_data->slip_data = slip_data;

	    x1f4_fini_mxdeck(&last_slip->data);

	    status = air_ceil(parser_data, slip_data, last_slip);

	    M_FREE(parser_data, last_slip);
	}
    }

    return status;
}


static int
air_post(struct parser_type *parser_data)
{
    void *v1st, *v2nd;

    v1st = parser_data->v1st;
    v2nd = parser_data->v2nd;

    if (v1st) {
	M_FREE(parser_data, v1st);
    }
    if (v2nd) {
	M_FREE(parser_data, v2nd);
    }

    return 0;
}


static int
air_raCk(struct parser_type *parser_data, unsigned *shift)
{
    int status;

    if (parser_data->class & 2) {
	status = air_rack(parser_data, shift);
    } else {
	status = air_slip(parser_data, shift);
    }

    return status;
}


static int
air_rack(struct parser_type *parser_data, unsigned *shift)
{
    int status = 0;
    struct hook_type *hook_data;

#if __DEBUG_RACK__
    ddebug_head("break", 5);
    ddebug_1("    level: %2u\n", parser_data->level);
    if (1) {
	struct hook_type *hook_data;
	struct slip_type *slip_data;
	unsigned level = -1;

	hook_data = parser_data->hook_data;
	while (hook_data) {
	    ddebug_1("    level: %2u ", hook_data->level);
	    if (hook_data->class == CASE_LOOP) {
		ddebug_0("LOOP");
	    } else if (hook_data->class == CASE_POST) {
		ddebug_0("POST");
	    } else if (hook_data->class == CASE_TEST) {
		ddebug_0("TEST");
	    } else if (hook_data->class == ELSE_CASE) {
		ddebug_0("ELSE");
	    } else {
		ddebug_0("FUCK");
	    }
	    ddebug_0("\n");
	    if (level == -1) {
		if (0) {
		} else if (hook_data->class == CASE_LOOP) {
		    level = hook_data->level;
		} else if (hook_data->class == CASE_POST) {
		    level = hook_data->level;
		}
	    }

	    hook_data = hook_data->hook_data;
	}

	slip_data = parser_data->slip_data;
	while (slip_data) {
	    unsigned count;

	    ddebug_1("    level: %2u", slip_data->level);
	    count = slip_data->count;
	    if (slip_data->last_slip) {
		count -= slip_data->last_slip->trail;
	    }
	    ddebug_1(" %2u nodes", count);
	    ddebug_0("\n");
	    if (count) {
		if (level < slip_data->level) {
		    struct c1_miss_type *miss_data;

		    miss_data = slip_data->miss_data;
		    while (count) {
			count--;
			ddebug_0("\t");
			ddebug_0(((struct x1f4_variable_type *)
				  miss_data->data)->name);
			ddebug_0("\n");
			miss_data = miss_data->last_miss;
		    }
		}
	    }

	    slip_data = slip_data->last_slip;
	}
    }
    ddebug_tail();
#endif				/* __DEBUG_RACK__ */

    hook_data = parser_data->hook_data;
    while (true(hook_data)) {
	if (hook_data->class == CASE_LOOP
	    || hook_data->class == CASE_POST) {
	    struct slip_type *slip_data;
	    unsigned level;

	    level = hook_data->level;

	    *shift = level;

	    slip_data = parser_data->slip_data;
	    while (slip_data) {
		if (level < slip_data->level) {
		    unsigned count;

		    count = slip_data->count;
		    if (slip_data->last_slip) {
			count -= slip_data->last_slip->trail;
		    }

		    status = _x1f4_c1_fit_sweep
			(parser_data, count, slip_data->miss_data);
		    if (status) {
			break;
		    } else {
			slip_data = slip_data->last_slip;
		    }
		} else {
		    break;
		}
	    }

	    break;
	} else {
	    hook_data = hook_data->hook_data;
	}
    }

    return status;
}


static int
air_slip(struct parser_type *parser_data, unsigned *shift)
{
    struct hook_type *hook_data;

    hook_data = parser_data->hook_data;
    while (1) {
	if (hook_data->class == CASE_LOOP
	    || hook_data->class == CASE_POST) {
	    *shift = hook_data->level;

	    break;
	} else {
	    hook_data = hook_data->hook_data;
	}
    }

    return 0;
}


static int
air_ways(struct parser_type *parser_data)
{
    int status;
    void *variable_tree;

    variable_tree = parser_data->variable_tree;
    if (!variable_tree) {
	status = 0;
    } else {
	x1f4_fini_mxdeck(&variable_tree);

	parser_data->variable_tree = NULL;

	status = air_miss(parser_data);
    }

    return status;
}


static int
fit_miss(struct parser_type *parser_data)
{
    int status;
    struct slip_type *slip_data;

    slip_data = parser_data->slip_data;
    if (!slip_data) {
	status = 0;
    } else {
	do {
	    struct slip_type *slip_free;

	    slip_free = slip_data;
	    slip_data = slip_data->last_slip;

	    {
		void *data;

		data = (void *) slip_free->data;
		if (data != parser_data->variable_deck) {
		    x1f4_fini_mxdeck(&data);
		}
	    }

	    status = air_ceil(parser_data, slip_data, slip_free);

	    M_FREE(parser_data, slip_free);

	    if (!slip_data) {
		parser_data->slip_data = NULL;
		break;
	    } else {
		if (status) {
		    parser_data->slip_data = slip_data;
		    break;
		}
	    }
	} while (1);
    }

    return status;
}


#if 0
static int
fit_post(struct parser_type *parser_data)
{
    int status = 0;

    do {
	struct c1_program_type *program_data;
	unsigned sxxx;
	void *v1st, *v2nd;

	v1st = parser_data->v1st;
	v2nd = parser_data->v2nd;

	program_data = parser_data->program_data;

	sxxx = parser_data->s1st;
	if (parser_data->r1st < sxxx) {
	    status = M_MODE(parser_data, &v1st, sxxx);
	    if (status) {
		v1st = parser_data->v1st;
		if (v1st) {
		    M_FREE(parser_data, v1st);
		}
		if (v2nd) {
		    M_FREE(parser_data, v2nd);
		}

		break;
	    }
	}

	program_data->v1st = v1st;

# if __SAVE_STACK_SIZE__
	program_data->s1st = sxxx;
# endif				/* __SAVE_STACK_SIZE__ */

	sxxx = parser_data->s2nd;
	if (parser_data->r2nd < sxxx) {
	    status = M_MODE(parser_data, &v2nd, sxxx);
	    if (status) {
		v2nd = parser_data->v2nd;
		if (v2nd) {
		    M_FREE(parser_data, v2nd);
		}

		break;
	    }
	}

	program_data->v2nd = v2nd;

# if __SAVE_STACK_SIZE__
	program_data->s2nd = sxxx;
# endif				/* __SAVE_STACK_SIZE__ */

	{
	    struct c1_node_type *node_data;

	    node_data = program_data->node;
	    while (node_data) {
		void *data;

		data = node_data->data.data;
		if (data) {
		    x1f4_miss_expression(data, v1st, v2nd);
		} else {
		    data = (node_data + 1)->data.data;
		    if (data) {
			x1f4_miss_expression(data, v1st, v2nd);
		    }
		}

		node_data = node_data->node_data;
	    }
	}
    } while (0);

    return status;
}
#endif				/* 0 */


static int
fit_slip(struct parser_type *parser_data, int type,
	 struct c1_program_type *program_data)
{
    int status;

    do {
	if (parser_data->flags & LEAD_DATATEXT) {
	    const struct c1_context_type *context_data;

	    context_data = parser_data->context_data;

	    if (type < X1f4_E4_LAST) {
		if (type == X1f4_E4_TEXT) {
		    program_data->u.data = context_data->near_f.data;
		    program_data->u.near = _x1f4_c1_post_text;
		    program_data->v.c.link = context_data->near_f.link;

		    break;
		}
	    } else {
		const struct c1_type_type *type_data;

		if (X1f4_E4_CALL < type) {
		    program_data->u.data = context_data->near_f.data;
		    program_data->u.near = _x1f4_c1_post_call;
		    program_data->v.f.pick = context_data->near_f.pick;

		    break;
		}

		type_data = parser_data->type_data;
		if (type_data) {
		    const char *name;

		    name = type_data->name;
		    while (name) {
			if (type_data->type == type) {
			    break;
			}

			type_data++;

			name = type_data->name;
		    }

		    if (name) {
			if (type_data->lead) {
			    program_data->u.data = context_data->near_f.data;
			    program_data->u.near = _x1f4_c1_post_lead;
			    program_data->v.f.pick = context_data->near_f.pick;
			    program_data->v.f.text = type_data;

			    break;
			}
		    }
		}
	    }

	    if (parser_data->flags & TURNCAST_LINK) {
		if (type == X1f4_E4_CASE) {
		    const struct c1_context_type *context_data;

		    context_data = parser_data->context_data;

		    program_data->u.data = context_data->near_f.data;
		    program_data->u.near = _x1f4_c1_post_cast;
		    program_data->v.f.pick = context_data->near_f.pick;
		    program_data->v.f.text = context_data->link_g.text;

		    break;
		}
	    }
	}

	program_data->u.near = NULL;
    } while (0);

    if (program_data->u.near) {
	status = _x1f4_c1_fit_trans(parser_data);
    } else {
	status = 0;
    }

    return status;
}


static int
fix_aiLe(struct parser_type *parser_data)
{
    int status;

    status = extend_state(parser_data);
    if (status) {
    } else {
	status = fix_aile(parser_data);
    }

    return status;
}


static int
fix_aiMe(struct parser_type *parser_data, int class)
{
    int status;

    status = extend_state(parser_data);
    if (status) {
    } else {
	status = fix_aime(parser_data, class);
    }

    return status;
}


static int
fix_aile(struct parser_type *parser_data)
{
    int status;

    {
	do {
	    {
		{
		    struct hook_type *hook_data;

		    status = M_LINK
			(parser_data, &hook_data, sizeof(struct hook_type));
		    if (status) {
			status = ALLOC_ERROR;

			break;
		    } else {
			hook_data->hook_data = parser_data->hook_data;

			parser_data->hook_data = hook_data;

			hook_data->class = CASE_POST;
			hook_data->level = parser_data->level;
			hook_data->node_data = parser_data->tail_node;
		    }
		}
	    }

	    parser_data->level++;

	    parser_data->rack++;

	    parser_data->head_line = line_root;

	    parser_data->program = (const char *) parser_data->program + 1;
	} while (0);
    }

    return status;
}


static int
fix_aime(struct parser_type *parser_data, int class)
{
    const char *e;
    int status;
    struct x1f4_attributes_type *attributes;
    void *expression;

    e = parser_data->program;

    attributes = &parser_data->attributes;

    attributes->terminator = 0;

    e++;

    status = x1f4_inIt_expression
	(&expression, &e, X1f4_E4_SLIPTEST | parser_data->e4_flags,
	 attributes);
    if (status) {
	if (status == X1f4_E4_ALLOC_ERROR) {
	    status = ALLOC_ERROR;
	} else {
	    status = _x1f4_c1_080707_error_0(parser_data->back_data, e);
	}
    } else {
	do {
	    {
		int type;

		type = x1f4_type_expression(expression);
		if (type == X1f4_E4_BILL || type == X1f4_E4_MODE
		    || type == X1f4_E4_REAL) {
		} else {
		    if (type == X1f4_E4_TEXT || X1f4_E4_LAST < type) {
			status = _x1f4_c1_091025_error_0
			    (parser_data->back_data, e, type);
		    } else {
			status = _x1f4_c1_080707_error_1
			    (parser_data->back_data, e);
		    }

		    if (expression) {
			x1f4_fini_expression(&expression);
		    }

		    break;
		}
	    }

	    if (true(*e == 0x29)) {
		e++;
	    } else {
		parser_data->slip(&e);

		if (*e == 0x29) {
		    e++;
		} else {
		    status = _x1f4_c1_080707_error_2
			(parser_data->back_data, e);
		    if (true(expression)) {
			x1f4_fini_expression(&expression);
		    }

		    break;
		}
	    }
	    {
		parser_data->slip(&e);

		if (*e == 0x7b) {
		    e++;
		} else {
		    status = _x1f4_c1_080707_error_3
			(parser_data->back_data, e);
		    if (true(expression)) {
			x1f4_fini_expression(&expression);
		    }

		    break;
		}
	    }

	    {
		struct c1_node_type *node_data;

		status = ink_node(parser_data, &node_data, 1);
		if (status) {
		    if (true(expression)) {
			x1f4_fini_expression(&expression);
		    }

		    break;
		} else {
		    struct hook_type *hook_data;

		    status = M_LINK
			(parser_data, &hook_data, sizeof(struct hook_type));
		    if (status) {
			status = ALLOC_ERROR;
			M_FREE(parser_data, node_data);
			if (true(expression)) {
			    x1f4_fini_expression(&expression);
			}

			break;
		    } else {
			hook_data->hook_data = parser_data->hook_data;

			parser_data->hook_data = hook_data;

			hook_data->class = class;
			hook_data->level = parser_data->level;
			hook_data->node_data = node_data;

			node_data[0].state = line_copy(parser_data);

			node_data[0].data.data = NULL;
			node_data[1].data.data = expression;

			if (parser_data->flags & LINE_OPTIMIZE) {
			    fix_node(parser_data, expression);
			}

			{
			    struct c1_node_type *tail_node;

			    tail_node = parser_data->tail_node;
			    if (tail_node) {
				tail_node->node_data = node_data;
			    } else {
				parser_data->head_node = node_data;
			    }

			    parser_data->tail_node = node_data;
			}
		    }
		}
	    }

	    parser_data->level++;

	    parser_data->head_line = line_root;
	} while (0);
    }

    parser_data->program = e;

    return status;
}


static int
fix_back(struct parser_type *parser_data)
{
    int status;

    if (!parser_data->level) {
	status = _x1f4_c1_080707_error_4
	    (parser_data->back_data, parser_data->program);
    } else {
	do {
	    /*
	     * the _fit_sweep processing should occur before hooks processing.
	     */

	    status = air_nets(parser_data);
	    if (status) {
		break;
	    }

	    parser_data->level--;

	    status = air_ways(parser_data);
	    if (status) {
		break;
	    }

	    {
		struct hook_type *hook_data;

		hook_data = parser_data->hook_data;
		if (!hook_data) {
		    parser_data->head_line = lock_root;
		} else {
		    if (hook_data->level != parser_data->level) {
			parser_data->head_line = lock_root;
		    } else {
			status = set_hook(parser_data, hook_data);
			if (status) {
			    break;
			}
		    }
		}
	    }

	    parser_data->program = (const char *) parser_data->program + 1;
	} while (0);
    }

    return status;
}


static int
fix_bill(struct parser_type *parser_data)
{
    return fix_type(parser_data, 0, X1f4_E4_BILL);
}


static int
fix_case(struct parser_type *parser_data, int class)
{
    const char *e;
    int status;

    e = parser_data->program;

    parser_data->slip(&e);

    parser_data->program = e;

    if (*e != 0x28) {
	status = _x1f4_c1_080707_error_5(parser_data->back_data, e);
    } else {
	e++;
	status = fix_aiMe(parser_data, class);
    }

    return status;
}


static int
fix_cell(struct parser_type *parser_data)
{
    return fix_type
	(parser_data, parser_data->side, parser_data->cell_type->type);
}


static int
fix_data(struct parser_type *parser_data, const char *name, unsigned length,
	 int type)
{
    int status;
    struct c1_miss_type *miss_data;

    status = M_LINK(parser_data, &miss_data, sizeof(struct c1_miss_type));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	struct x1f4_variable_type *variable_data;

	status = M_LINK
	    (parser_data, &variable_data,
	     sizeof(struct x1f4_variable_type) + length + 1);
	if (status) {
	    M_FREE(parser_data, miss_data);
	    status = ALLOC_ERROR;
	} else {
	    char *data;
	    void *variable_tree;

	    data = (char *) (variable_data + 1);
	    memcpy(data, name, length);
	    data[length] = 0;

	    variable_tree = parser_data->variable_tree;

	    if (variable_tree) {
	    } else {
		struct x1f4_mxdeck_type mxdeck;

		mxdeck.trans = &parser_data->m;

		status = x1f4_init_mxdeck
		    (&variable_tree, X1f4_MXDECK_TRANS_MASK, &mxdeck);
	    }

	    status = x1f4_post_mxpath
		(variable_tree, data, length, miss_data);
	    if (status) {
		if (parser_data->variable_tree) {
		} else {
		    x1f4_fini_mxdeck(&variable_tree);
		}

		M_FREE(parser_data, variable_data);
		M_FREE(parser_data, miss_data);

		if (status != X1f4_MXDECK_EVER_MATCH) {
		    status = ALLOC_ERROR;
		} else {
		    status = _x1f4_c1_080707_error_6
			(parser_data->back_data, name, length);
		}
	    } else {
		do {
		    const struct c1_type_type *cell_type = NULL;

		    variable_data->length = length;
		    variable_data->name = data;
		    variable_data->type = type;

		    if (1) {
			void *link;

			variable_data->flags = X1f4_E4_UNIVERSAL;

			link = parser_data->base;

			miss_data->link = link;

			parser_data->base =
			    (char *) link + sizeof(struct c1_lead_type);

			if (0) {
			} else {
			    if (type < X1f4_E4_LAST) {
			    } else {
				if (type < X1f4_E4_CALL) {
				    cell_type = parser_data->cell_type;
				} else {
				    cell_type = &_x1f4_af_last_type;
				}
			    }
			}
		    } else {
#if 0
			struct c1_lead_type *link_data;

			variable_data->flags = 0;

			status = M_LINK(parser_data, &link_data,
					sizeof(struct c1_lead_type));
			if (status) {
			    M_FREE(parser_data, variable_data);
			    M_FREE(parser_data, miss_data);

			    status = ALLOC_ERROR;

			    break;
			}

			miss_data->link = link_data;

			if (type == X1f4_E4_TEXT) {
			    const X1f4_E4_C_TEXT *text;

			    text = (void *) link_data;
			    *text = x1f4_c1_empty_string;
			} else {
			    if (type < X1f4_E4_LAST) {
			    } else {
				if (type < X1f4_E4_CALL) {
				    int (*link) (void *, void **);

				    cell_type = parser_data->cell_type;

				    link = cell_type->link;
				    if (link) {
					void *cell;

					status = link
					    (cell_type->context, &cell);
					if (status) {
					    M_FREE(parser_data, variable_data);
					    M_FREE(parser_data, link_data);
					    M_FREE(parser_data, miss_data);

					    /*
					     * BUGS
					     *
					     * the (variable) tree should be
					     * restored.  its record (in parser
					     * record) must be updated.
					     */

					    status = PARSE_ERROR;

					    break;
					} else {
					    const X1f4_E4_C_USER *user;

					    user = (void *) link_data;
					    *user = cell;
					}
				    }
				} else {
				    {
					const X1f4_E4_C_USER *user;
					const struct x1f4_linetext_type
					    *linetext_data;

					user = (void *) link_data;
					/*
					 * TODO
					 *
					 * the call may be eliminated by
					 * retrieving the function definition
					 * with the preceding e4jack call
					 */
					x1f4_pick_e4fine
					    (parser_data->e4fine, type,
					     &linetext_data);
					*user = (void *) linetext_data;
				    }
				}
			    }
			}
#endif				/* 0 */
		    }

		    miss_data->data = variable_data;
		    miss_data->type = cell_type;

		    parser_data->variable_tree = variable_tree;

		    parser_data->count++;

		    miss_data->last_miss = parser_data->miss_data;
		    parser_data->miss_data = miss_data;
		} while (0);
	    }
	}
    }

    return status;
}


static int
fix_fast(struct parser_type *parser_data)
{
    const char *e;
    int status;
    struct x1f4_attributes_type *attributes;
    void *expression;

    e = parser_data->program;

    attributes = &parser_data->attributes;

    attributes->terminator = 0x3b;

    attributes->sequence_set.type = parser_data->shift;

    status = x1f4_iNIt_expression
	(&expression, &e, parser_data->e4_flags | X1f4_E4_SEQUENCE,
	 attributes);
    if (status) {
	if (status == X1f4_E4_ALLOC_ERROR) {
	    status = ALLOC_ERROR;
	} else {
	    status = _x1f4_c1_130608_error_0
		(parser_data->back_data, e, status);
	}
    } else {
	do {
#if 0
	    int type;
#endif				/* 0 */

	    if (true(*e == 0x3b)) {
		e++;
	    } else {
		parser_data->slip(&e);

		if (*e == 0x3b) {
		    e++;
		} else {
		    status = _x1f4_c1_080707_error_2
			(parser_data->back_data, e);
		    if (expression) {
			x1f4_fini_expression(&expression);
		    }

		    break;
		}
	    }

#if 0
	    type = x1f4_type_expression(expression);
	    if (type ^ parser_data->shift) {
		status = _x1f4_c1_080707_error_e
		    (parser_data->back_data, parser_data->program,
		     parser_data->shift, type);
		if (true(expression)) {
		    x1f4_fini_expression(&expression);
		}

		break;
	    }
#endif				/* 0 */

	    if (expression) {
		struct c1_node_type *node_data;

		status = ink_node(parser_data, &node_data, 0);
		if (status) {
		    if (true(expression)) {
			x1f4_fini_expression(&expression);
		    }

		    break;
		} else {
		    struct c1_program_type *program_data;

		    program_data = parser_data->program_data;

		    program_data->line = node_data;

		    node_data[0].state = line_copy(parser_data);

		    node_data[0].data.data = expression;

		    if (parser_data->flags & LINE_OPTIMIZE) {
			fix_node(parser_data, expression);
		    }

		    {
			struct c1_node_type *tail_node;

			tail_node = parser_data->tail_node;
			if (tail_node) {
			    tail_node->node_data = node_data;
			} else {
			    parser_data->head_node = node_data;
			}

			parser_data->tail_node = node_data;
		    }

#if 0
		    status = fit_slip(parser_data, type, program_data);
#else
		    status = fit_slip
			(parser_data, parser_data->shift, program_data);
#endif				/* 0 */
		}
	    }
	} while (0);
    }

    parser_data->program = e;

    return status;
}


static int
fix_half(struct parser_type *parser_data, struct hook_type *hook_data)
{
    const char *e;
    int status;
    struct x1f4_attributes_type *attributes;
    void *expression;

    e = parser_data->program;

    attributes = &parser_data->attributes;

    attributes->terminator = 0;

    e++;

    status = x1f4_inIt_expression
	(&expression, &e, X1f4_E4_SLIPTEST | parser_data->e4_flags,
	 attributes);
    if (status) {
	if (status == X1f4_E4_ALLOC_ERROR) {
	    status = ALLOC_ERROR;
	} else {
	    status = _x1f4_c1_080707_error_0(parser_data->back_data, e);
	}
    } else {
	do {
	    {
		int type;

		type = x1f4_type_expression(expression);
		if (type == X1f4_E4_BILL || type == X1f4_E4_MODE
		    || type == X1f4_E4_REAL) {
		} else {
		    if (type == X1f4_E4_TEXT || X1f4_E4_LAST < type) {
			status = _x1f4_c1_091025_error_0
			    (parser_data->back_data, e, type);
		    } else {
			status = _x1f4_c1_080707_error_1
			    (parser_data->back_data, e);
		    }

		    if (expression) {
			x1f4_fini_expression(&expression);
		    }

		    break;
		}
	    }

	    if (true(*e == 0x29)) {
		e++;
	    } else {
		parser_data->slip(&e);

		if (*e == 0x29) {
		    e++;
		} else {
		    status = _x1f4_c1_080707_error_2
			(parser_data->back_data, e);
		    if (true(expression)) {
			x1f4_fini_expression(&expression);
		    }

		    break;
		}
	    }
	    {
		parser_data->slip(&e);

		if (*e == 0x3b) {
		} else {
		    status = _x1f4_c1_080707_error_7
			(parser_data->back_data, e);
		    if (true(expression)) {
			x1f4_fini_expression(&expression);
		    }

		    break;
		}
	    }

	    {
		struct c1_node_type *node_data;

		status = ink_node(parser_data, &node_data, 1);
		if (status) {
		    if (true(expression)) {
			x1f4_fini_expression(&expression);
		    }

		    break;
		} else {
		    struct c1_node_type *post_node;

		    status = ink_node(parser_data, &post_node, 1);
		    if (status) {
			M_FREE(parser_data, node_data);
			if (true(expression)) {
			    x1f4_fini_expression(&expression);
			}

			break;
		    } else {
			node_data[0].state = line_copy(parser_data);

			node_data[0].data.data = NULL;
			node_data[1].data.data = expression;

			node_data[0].node_data = post_node;
			node_data[1].node_data = post_node;

			post_node[0].state = 0;

			post_node[0].data.data = NULL;
			post_node[1].data.data = NULL;

			if (parser_data->flags & LINE_OPTIMIZE) {
			    fix_node(parser_data, expression);
			}

			{
			    struct c1_node_type *tail_node;

			    tail_node = parser_data->tail_node;
			    if (true(tail_node)) {
				tail_node->node_data = node_data;
			    } else {
				parser_data->head_node = node_data;
			    }

			    parser_data->tail_node = post_node;
			}

			{
			    struct c1_node_type *half_node;

			    half_node = hook_data->node_data;
			    if (!half_node) {
				post_node[1].node_data =
				    parser_data->head_node;
			    } else {
				post_node[1].node_data = half_node->node_data;
			    }
			}

			parser_data->hook_data = hook_data->hook_data;

			M_FREE(parser_data, hook_data);
		    }
		}
	    }

	    {
		if (parser_data->head_rack) {
		    net_red(parser_data);
		}
	    }

	    parser_data->rack--;

	    parser_data->head_line = lock_root;
	} while (0);
    }

    parser_data->program = e;

    return status;
}


static int
fix_heAd(struct parser_type *parser_data)
{
    int status;

    status = extend_state(parser_data);
    if (status) {
    } else {
	status = fix_head(parser_data);
    }

    return status;
}


static int
fix_head(struct parser_type *parser_data)
{
    int status;

    {
	status = 0;

	{
	    parser_data->level++;

	    parser_data->head_line = line_root;

	    parser_data->program = (const char *) parser_data->program + 1;
	}
    }

    return status;
}


static int
fix_laSt(struct parser_type *parser_data)
{
    const char *e;
    int status;

    e = parser_data->program;
    if (*e == 0x3b) {
	parser_data->program = e + 1;

	status = 0;
    } else {
	status = extend_state(parser_data);
	if (status) {
	} else {
	    status = fix_last(parser_data);
	}
    }

    return status;
}


static int
fix_last(struct parser_type *parser_data)
{
    const char *e;
    int status;
    struct x1f4_attributes_type *attributes;
    void *expression;

    e = parser_data->program;

    attributes = &parser_data->attributes;

    attributes->terminator = 0x3b;

    status = x1f4_iNIt_expression
	(&expression, &e, parser_data->e4_flags, attributes);
    if (status) {
	if (status == X1f4_E4_ALLOC_ERROR) {
	    status = ALLOC_ERROR;
	} else {
	    status = _x1f4_c1_080707_error_0(parser_data->back_data, e);
	}
    } else {
	do {
	    if (true(*e == 0x3b)) {
		e++;
	    } else {
		parser_data->slip(&e);

		if (*e == 0x3b) {
		    e++;
		} else {
		    status = _x1f4_c1_080707_error_2
			(parser_data->back_data, e);
		    if (expression) {
			x1f4_fini_expression(&expression);
		    }

		    break;
		}
	    }

	    if (expression) {
		struct c1_node_type *node_data;

		status = ink_node(parser_data, &node_data, 0);
		if (status) {
		    if (true(expression)) {
			x1f4_fini_expression(&expression);
		    }

		    break;
		} else {
		    node_data[0].state = line_copy(parser_data);

		    node_data[0].data.data = expression;

		    if (parser_data->flags & LINE_OPTIMIZE) {
			fix_node(parser_data, expression);
		    }

		    {
			struct c1_node_type *tail_node;

			tail_node = parser_data->tail_node;
			if (tail_node) {
			    tail_node->node_data = node_data;
			} else {
			    parser_data->head_node = node_data;
			}

			parser_data->tail_node = node_data;
		    }
		}
	    }
	} while (0);
    }

    parser_data->program = e;

    return status;
}


static int
fix_loop(struct parser_type *parser_data)
{
    int status;

    status = fix_case(parser_data, CASE_LOOP);
    if (status) {
    } else {
	parser_data->rack++;
    }

    return status;
}


static int
fix_mode(struct parser_type *parser_data)
{
    return fix_type(parser_data, 0, X1f4_E4_MODE);
}


static int
fix_node(struct parser_type *parser_data, void *expression)
{
    int status;
    unsigned r1st, r2nd, s1st, s2nd;

    r1st = parser_data->r1st;
    r2nd = parser_data->r2nd;
    s1st = parser_data->s1st;
    s2nd = parser_data->s2nd;

    do {
	void *v1st, *v2nd;

	v1st = parser_data->v1st;
	v2nd = parser_data->v2nd;

	if (r1st != s1st || r2nd != s2nd) {
	    if (r1st != s1st) {
		status = M_MODE(parser_data, &v1st, s1st);
		if (status) {
		    break;
		} else {
		    parser_data->r1st = s1st;
		    parser_data->v1st = v1st;
		}
	    }

	    if (r2nd != s2nd) {
		status = M_MODE(parser_data, &v2nd, s2nd);
		if (status) {
		    break;
		} else {
		    parser_data->r2nd = s2nd;
		    parser_data->v2nd = v2nd;
		}
	    }
	}

	status = x1f4_miss_expression(expression, v1st, v2nd);
	if (status) {
	} else {
	    status = x1f4_line_expression(expression);
	}
    } while (0);

    return status;
}


static int
fix_post(struct parser_type *parser_data)
{
    const char *e;
    int status;

    e = parser_data->program;

    parser_data->slip(&e);

    parser_data->program = e;

    if (*e != 0x7b) {
	status = _x1f4_c1_080707_error_8(parser_data->back_data, e);
    } else {
	e++;
	status = fix_aiLe(parser_data);
    }

    return status;
}


static int
fix_rack(struct parser_type *parser_data)
{
    const char *e;
    int status;

    e = parser_data->program;

    parser_data->slip(&e);

    if (*e != 0x3b) {
	status = _x1f4_c1_080707_error_9(parser_data->back_data, e);
    } else {
	if (!parser_data->rack) {
	    status = _x1f4_c1_080707_error_a(parser_data->back_data, e);
	} else {
	    unsigned shift;

	    status = air_raCk(parser_data, &shift);
	    if (status) {
	    } else {
		struct hook_type *hook_data;

		status = M_LINK(parser_data, &hook_data,
				sizeof(struct hook_type));
		if (status) {
		    status = ALLOC_ERROR;
		} else {
		    struct c1_node_type *node_data;

		    status = ink_node(parser_data, &node_data, 1);
		    if (status) {
			M_FREE(parser_data, hook_data);
		    } else {
			{
			    struct hook_type *tail_rack;

			    tail_rack = parser_data->tail_rack;
			    if (tail_rack) {
				tail_rack->hook_data = hook_data;
			    } else {
				parser_data->head_rack = hook_data;
			    }

			    parser_data->tail_rack = hook_data;
			}

			node_data[0].state = 0;

			node_data[0].data.data = NULL;
			node_data[1].data.data = NULL;

			hook_data->node_data = node_data;

			hook_data->level = shift;

			e++;

			{
			    struct c1_node_type *tail_node;

			    tail_node = parser_data->tail_node;
			    if (tail_node) {
				tail_node->node_data = node_data;
			    } else {
				parser_data->head_node = node_data;
			    }

			    parser_data->tail_node = node_data;
			}
		    }
		}
	    }
	}
    }

    parser_data->program = e;

    return status;
}


static int
fix_real(struct parser_type *parser_data)
{
    return fix_type(parser_data, 0, X1f4_E4_REAL);
}


static int
fix_side(struct parser_type *parser_data)
{
    const char *e;
    int status;

    e = parser_data->program;
    if (*e == 0x3b) {
	status = _x1f4_c1_090828_error_1(parser_data->back_data, e);
    } else {
	status = extend_state(parser_data);
	if (status) {
	} else {
	    status = fix_fast(parser_data);
	}
    }

    return status;
}


static int
fix_test(struct parser_type *parser_data)
{
    return fix_case(parser_data, CASE_TEST);
}


static int
fix_text(struct parser_type *parser_data)
{
    return fix_type(parser_data, 0, X1f4_E4_TEXT);
}


static int
fix_turn(struct parser_type *parser_data)
{
    int status;

    if (parser_data->level) {
	status = _x1f4_c1_090828_error_0
	    (parser_data->back_data, parser_data->program);
    } else {
	if (parser_data->track == TURN_COMPLETION) {
	    status = fix_side(parser_data);
	} else {
	    status = _x1f4_c1_090828_error_0
		(parser_data->back_data, parser_data->program);
	}
    }

    return status;
}


static int
fix_type(struct parser_type *parser_data, int side, int type)
{
    const char *e;
    int status;

    e = parser_data->program;

    while (1) {
	int c, jack;

	parser_data->slip(&e);

	c = *(const unsigned char *) e;
	if (c) {
	    const char *f;
	    unsigned size;

	    f = e;
	    if (c == '(') {
		struct c1_back_type *back_data;
		struct x1f4_ejrecord_type *ejrecord_data;
		unsigned bits;

		back_data = parser_data->back_data;
		if (back_data) {
		    ejrecord_data = &back_data->data.higherof.ejrecord;
		} else {
		    ejrecord_data = NULL;
		}

		status = x1f4_pick_e4jack
		    (type, &jack, &bits, &size, &f, &e, 1, 0,
		     parser_data->e4fine, parser_data->slip,
		     parser_data->type_data, parser_data->side_data,
		     ejrecord_data);
		if (status) {
		    if (status == X1f4_E4JACK_ALLOC_ERROR) {
			status = ALLOC_ERROR;
		    } else {
			status = _x1f4_c1_111221_error_0
			    (parser_data->back_data, f, status);
		    }

		    break;
		} else {
		    parser_data->cell_type = NULL;
		}
	    } else {
		if (side) {
		    status = _x1f4_c1_110725_error_0
			(parser_data->back_data, f, type);
		    break;
		} else {
		    if (type != X1f4_E4_VOID) {
			way_red(&e);
			jack = type;
		    }
		    size = e - f;
		}
	    }
	    if (size) {
		status = x1f4_look_atkey_l(f, size, _x1f4_c1_text_root);
		if (status) {
		    const struct c1_type_type *type_data;

		    type_data = parser_data->side_data;
		    if (type_data) {
			const void *cell;

			if (get_type(&f, &cell, type_data)) {
			} else {
			    status = _x1f4_c1_080707_error_b
				(parser_data->back_data, f - size, size);
			    break;
			}
		    }
		    type_data = parser_data->type_data;
		    if (type_data) {
			const void *cell;

			if (get_type(&f, &cell, type_data)) {
			} else {
			    status = _x1f4_c1_080707_error_b
				(parser_data->back_data, f - size, size);
			    break;
			}
		    }

		    status = fix_data(parser_data, f, size, jack);
		    if (status) {
			break;
		    } else {
			parser_data->slip(&e);

			c = *(const unsigned char *) e;
			if (c == 0x2c) {
			    e++;
			} else {
			    if (c == 0x3b) {
				e++;
				break;
			    } else {
				status = _x1f4_c1_080707_error_c
				    (parser_data->back_data, e);
				break;
			    }
			}
		    }
		} else {
		    status = _x1f4_c1_080707_error_b
			(parser_data->back_data, f, size);
		    break;
		}
	    } else {
		status = _x1f4_c1_120115_error_0(parser_data->back_data, f);
		break;
	    }
	} else {
	    status = _x1f4_c1_080707_error_2(parser_data->back_data, e);
	    break;
	}
    }

    parser_data->program = e;

    return status;
}


static int
fix_void(struct parser_type *parser_data)
{
    return fix_type(parser_data, 0, X1f4_E4_VOID);
}


static int
get_line(unsigned *line, struct parser_type *parser_data)
{
    const char *e;
    int c, status;

    e = parser_data->program;

    status = 0;

    parser_data->slip(&e);

    c = *(const unsigned char *) e;
    if (c) {
	if (c == 0x7b) {
	    *line = HEAD_CASE;
	} else {
	    if (c == 0x7d) {
		*line = BACK_CASE;
	    } else {
		const char *f;

		f = e;
		if (x1f4_head_ctkey(&e, parser_data->head_line, line)) {
		    const struct c1_type_type *side_data, *type_data;

		    /*
		     * TODO
		     *
		     * fix this horror, casing context
		     * (declaration/instruction) via _head_line_
		     */
		    side_data = parser_data->side_data;
		    type_data = parser_data->type_data;
		    if ((side_data || type_data)
			&& parser_data->head_line == line_root) {
			int delete, side;
			const void *cell;

			if (type_data) {
			    delete = get_type(&e, &cell, type_data);
			    if (delete) {
				if (side_data) {
				    delete = get_type(&e, &cell, side_data);
				    if (delete) {
				    } else {
					side = 1;
				    }
				}
			    } else {
				side = 0;
			    }
			} else {
			    delete = get_type(&e, &cell, side_data);
			    if (delete) {
			    } else {
				side = 1;
			    }
			}
			if (delete) {
			    *line = LAST_CASE;
			} else {
			    c = *(const unsigned char *) e;
			    if (c) {
				if (C_TYPE_X(parser_data->e_type_4, c)) {
				    *line = TYPE_CASE;
				    parser_data->side = side;
				    parser_data->cell_type = cell;
				} else {
				    do {
					if (c == '(') {
					    const char *g;

					    g = e + 1;
					    parser_data->slip(&g);
					    if (*g == '*') {
						*line = TYPE_CASE;
						parser_data->side = side;
						parser_data->cell_type = cell;
						break;
					    }
					}

					e = f;
					*line = LAST_CASE;
				    } while (0);
				}
			    } else {
				status = _x1f4_c1_080707_error_2
				    (parser_data->back_data, e);
			    }
			}
		    } else {
			*line = LAST_CASE;
		    }
		} else {
		    c = *(const unsigned char *) e;
		    if (c) {
			do {
			    if (C_TYPE_X(parser_data->e_type_4, c)) {
				parser_data->slip(&e);
				c = *(const unsigned char *) e;
				if (C_TYPE_X(c_type_1, c)) {
				    /*
				     * check for (non pointer) void case?
				     */

				    break;
				}
			    }
			    {
				unsigned this;

				this = *line;
				if (this < HALF_CASE) {
				    if (c == '(') {
					const char *g;

					g = e + 1;
					parser_data->slip(&g);
					if (*g == '*') {
					    break;
					}
				    }

				    /*
				     * FEATURES
				     *
				     * this one allows functions with intrinsic
				     * type names, but just as well all sort of
				     * stupid things...
				     */
				    e = f;
				    *line = LAST_CASE;
				} else {
				    if (this == CASE_TURN) {
				    } else {
					if (c != end_class[this]) {
					    /*
					     * FEATURES
					     *
					     * so many stupid things are
					     * allowed by this one, hopefully
					     * not too many...
					     */
					    e = f;
					    *line = LAST_CASE;
					}
				    }
				}
			    }
			} while (0);
		    } else {
			status = _x1f4_c1_080707_error_2
			    (parser_data->back_data, e);
		    }
		}
	    }
	}
    } else {
	*line = 0;
    }

    parser_data->program = e;

    return status;
}


static int
get_type(const char **deck, const void **cell,
	 const struct c1_type_type *type_data)
{
    const char *e, *name;
    int false = 1;

    e = *deck;

    name = type_data->name;
    while (name) {
	const char *miss;
	unsigned size;

	miss = e;

	size = type_data->size;
	while (size) {
	    if (*miss != *name) {
		break;
	    } else {
		miss++;
		name++;
		size--;
	    }
	}
	if (size) {
	} else {
	    false = 0;

	    *deck = miss;
	    *cell = type_data;

	    break;
	}

	type_data++;

	name = type_data->name;
    }

    return false;
}


static int
ink_back(struct parser_type *parser_data)
{
    int status;

    while (1) {
	unsigned line;

	status = get_line(&line, parser_data);
	if (status) {
	    break;
	}
	if (line == BACK_CASE) {
	    if (parser_data->level) {
	    } else {
		status = 0;
		if (1) {
		    break;
		}
	    }
	} else {
	    if (line) {
	    } else {
		status = _x1f4_c1_080707_error_f(parser_data->back_data);
		if (1) {
		    break;
		}
	    }
	}

	status = set_class[line](parser_data);
	if (status) {
	    break;
	}
    }

    return status;
}


static int
ink_byte(struct parser_type *parser_data)
{
    int status;

    while (1) {
	unsigned line;

	status = get_line(&line, parser_data);
	if (status) {
	    break;
	}
	if (line) {
	} else {
	    if (!parser_data->level) {
		status = 0;
	    } else {
		status = _x1f4_c1_080707_error_f(parser_data->back_data);
	    }

	    break;
	}

	status = set_class[line](parser_data);
	if (status) {
	    break;
	}
    }

    return status;
}


static int
ink_data(struct parser_type *parser_data)
{
    int status;

    parser_data->head_line = line_root;

    parser_data->variable_tree = NULL;

    parser_data->head_node = NULL;
    parser_data->tail_node = NULL;

    parser_data->head_rack = NULL;
    parser_data->hook_data = NULL;
    parser_data->hook_slip = NULL;
    parser_data->tail_rack = NULL;

    parser_data->miss_data = NULL;

    parser_data->level = 0;

    parser_data->rack = 0;

    if (parser_data->track == BACK_COMPLETION) {
	status = ink_back(parser_data);
    } else {
	if (parser_data->track == BYTE_COMPLETION) {
	    status = ink_byte(parser_data);
	} else {
	    status = ink_turn(parser_data);
	}
    }

    {
	void *variable_tree;

	variable_tree = parser_data->variable_tree;
	if (variable_tree) {
	    x1f4_fini_mxdeck(&variable_tree);
	}
    }

    {
	struct hook_type *hook_data;

	hook_data = parser_data->hook_data;
	while (hook_data) {
	    struct hook_type *miss_hook;

	    miss_hook = hook_data;
	    hook_data = hook_data->hook_data;
	    M_FREE(parser_data, miss_hook);
	}
    }

    {
	struct hook_type *hook_data;

	hook_data = parser_data->head_rack;
	if (hook_data) {
	    parser_data->tail_rack->hook_data = parser_data->hook_slip;
	    parser_data->hook_slip = hook_data;
	}
    }

    if (status) {
    } else {
	/*
	 * looks like this one (since it may introduce new nodes) expects
	 * `hook_slip' sort of valid (or something).  hence it has to occur
	 * before `hook_slip' (final!?) processing...
	 */
	status = fit_miss(parser_data);
    }

    {
	struct hook_type *hook_data;

	hook_data = parser_data->hook_slip;
	if (hook_data) {
	    if (status) {
		do {
		    struct hook_type *miss_hook;

		    miss_hook = hook_data;
		    hook_data = hook_data->hook_data;
		    M_FREE(parser_data, miss_hook);
		} while (hook_data);
	    } else {
		do {
		    struct hook_type *miss_hook;

		    hook_data->node_data[1].node_data = NULL;

		    miss_hook = hook_data;
		    hook_data = hook_data->hook_data;
		    M_FREE(parser_data, miss_hook);
		} while (hook_data);
	    }
	}
    }

    {
	struct c1_node_type *tail_node;

	tail_node = parser_data->tail_node;
	if (tail_node) {
	    tail_node->node_data = NULL;
	    if (status) {
		air_mae(parser_data->head_node, parser_data->m.free,
			parser_data->m.data);
	    } else {
		parser_data->program_data->node = parser_data->head_node;
	    }
	}
    }

    if (status) {
	air_set(parser_data->miss_data, parser_data->flags,
		parser_data->m.free, parser_data->m.data);
    } else {
	parser_data->program_data->miss = parser_data->miss_data;
    }

    return status;
}


static int
ink_fine(struct parser_type *parser_data)
{
    int status;
    struct x1f4_e4fine_type e4fine;
    void *fine;

    e4fine.resource_set.data = parser_data->m.data;

    e4fine.resource_set.free = parser_data->m.free;
    e4fine.resource_set.link = parser_data->m.link;
    e4fine.resource_set.mode = parser_data->m.mode;

    status = x1f4_init_e4fine(&fine, X1f4_E4FINE_RESOURCE, &e4fine);
    if (status) {
    } else {
	parser_data->e4fine = fine;
	parser_data->program_data->fine = fine;
	parser_data->program_data->high = fine;
	parser_data->attributes.transfer_set.fine = fine;
    }

    return status;
}


static int
ink_node(struct parser_type *parser_data, struct c1_node_type **node,
	 unsigned shift)
{
    int status;
    struct c1_node_type *node_data;

    status = M_LINK
	(parser_data, &node_data, sizeof(struct c1_node_type) << shift);
    if (status) {
	status = ALLOC_ERROR;
    } else {
	*node = node_data;

	_x1f4_c1_hook_node(parser_data, node_data);
    }

    return status;
}


static int
ink_turn(struct parser_type *parser_data)
{
    int status;

    while (1) {
	unsigned line;

	status = get_line(&line, parser_data);
	if (status) {
	    break;
	}
	if (1) {
	    if (line) {
	    } else {
		status = _x1f4_c1_080707_error_f(parser_data->back_data);
		if (1) {
		    break;
		}
	    }
	}

	status = set_class[line](parser_data);
	if (status) {
	    break;
	} else {
	    if (line == CASE_TURN) {
		break;
	    }
	}
    }

    return status;
}


static int
extend_state(struct parser_type *parser_data)
{
    int status;

    do {
	void *variable_tree;

	variable_tree = parser_data->variable_tree;
	if (!variable_tree) {
	    status = 0;
	} else {
	    struct slip_type *slip_data;

	    status = M_LINK(parser_data, &slip_data, sizeof(struct slip_type));
	    if (status) {
		status = ALLOC_ERROR;
		break;
	    } else {
		struct slip_type *last_slip;

		last_slip = parser_data->slip_data;
		if (!last_slip) {
		    fix_day(parser_data, slip_data);

		    slip_data->data = variable_tree;
		    slip_data->last_slip = NULL;
		    slip_data->level = parser_data->level;

		    slip_data->miss_data = parser_data->miss_data;

		    slip_data->node_data = parser_data->tail_node;

		    parser_data->slip_data = slip_data;

		    parser_data->variable_tree = NULL;

		    parser_data->attributes.variable_set.context =
			variable_tree;
		} else {
		    if (1) {
			void *variable_slip;

			status = x1f4_copy_mxdeck
			    (&variable_slip, (void *) last_slip->data);
			if (status) {
			} else {
			    struct half_type half;

			    half.trans_data = &parser_data->m;
			    half.variable_slip = variable_slip;

			    status = x1f4_span_mxdeck
				(variable_tree, &half, net_tree);

			    variable_slip = half.variable_slip;

			    if (status) {
				x1f4_fini_mxdeck(&variable_slip);
			    } else {
				fix_day(parser_data, slip_data);

				slip_data->data = variable_slip;
				slip_data->last_slip = last_slip;
				slip_data->level = parser_data->level;

				slip_data->miss_data = parser_data->miss_data;

				slip_data->node_data = parser_data->tail_node;

				x1f4_fini_mxdeck(&variable_tree);

				parser_data->slip_data = slip_data;

				parser_data->variable_tree = NULL;

				parser_data->attributes.variable_set.context =
				    variable_slip;
			    }
			}
		    }

		    if (status) {
			status = ALLOC_ERROR;
			M_FREE(parser_data, slip_data);
			break;
		    }
		}
	    }
	}

	parser_data->head_line = lock_root;
    } while (0);

    return status;
}


static int
map_data(struct parser_type *parser_data)
{
    int status;

    parser_data->count = 0;

    parser_data->slip_data = NULL;

    status = ink_data(parser_data);

    air_fix(parser_data);

    return status;
}


static int
map_zero(struct parser_type *parser_data,
	 const struct c1_context_type *context_data)
{
    if (1) {
	parser_data->e4_flags |= X1f4_E4_RESOURCE;
    }
    {
	void *context;

	context = context_data->link_m.data;
	parser_data->m.data = context;
	parser_data->attributes.resource_set.context = context;
    }
    {
	int (*free) (void *, void *);

	free = context_data->link_m.free;
	parser_data->m.free = free;
	parser_data->attributes.resource_set.free = free;
    }
    {
	int (*link) (void *, void **, unsigned);

	link = context_data->link_m.link;
	parser_data->m.link = link;
	parser_data->attributes.resource_set.link = link;
    }
    {
	int (*mode) (void *, void **, unsigned);

	mode = context_data->link_m.mode;
	parser_data->m.mode = mode;
	parser_data->attributes.resource_set.mode = mode;
    }

    return 0;
}


static int
max_data(struct parser_type *parser_data)
{
    int status;

    do {
	if (1) {
	    void *e4fine;

	    e4fine = parser_data->e4fine;
	    if (e4fine) {
		parser_data->attributes.transfer_set.fine = e4fine;
		parser_data->program_data->high = e4fine;
	    } else {
		status = ink_fine(parser_data);
		if (status) {
		    break;
		}
	    }
	}

	status = set_data(parser_data);
    } while (0);

    if (status) {
	air_post(parser_data);
    } else {
	if (1) {
	    unsigned list, post, used;

	    air_post(parser_data);
	    post = (int) parser_data->base;
	    list = post + parser_data->s1st;
	    used = list + parser_data->s2nd;
	    parser_data->program_data->post = post;
	    parser_data->program_data->used = used;
	    parser_data->base = (void *) used;
	} else {
#if 0
	    status = fit_post(parser_data);
#endif				/* 0 */
	}
    }

    return status;
}


static int
net_data(struct parser_type *parser_data)
{
    int status;
    struct slip_type *slip_data;

    status = M_LINK(parser_data, &slip_data, sizeof(struct slip_type));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	slip_data->data =
	    (void *) parser_data->attributes.variable_set.context;
	slip_data->last_slip = NULL;
	slip_data->level = 0;

	slip_data->count = 0;
	slip_data->trail = 0;

	slip_data->node_data = NULL;

	parser_data->count = 0;

	parser_data->slip_data = slip_data;

	status = ink_data(parser_data);

	air_fix(parser_data);
    }

    return status;
}


static int
net_tree(void *half, const void *miss, const char *name, unsigned size)
{
    int status;
    struct half_type *half_data;
    void *variable_slip;
    const void **pick;

    half_data = half;

    variable_slip = half_data->variable_slip;

    if (x1f4_pick_mxpath(variable_slip, name, size, &pick)) {
	*pick = miss;

	status = 0;
    } else {
	status = x1f4_post_mxpath(variable_slip, name, size, miss);
    }

    half_data->variable_slip = variable_slip;

    return status;
}


static int
set_clip(struct parser_type *parser_data, struct hook_type *hook_data)
{
    int status;
    struct c1_node_type *node_data;

    status = ink_node(parser_data, &node_data, 1);
    if (status) {
    } else {
	struct c1_node_type *hook_node;

	hook_node = hook_data->node_data;

	node_data[0].state = 0;

	node_data[0].data.data = NULL;
	node_data[1].data.data = NULL;

	hook_node[1].node_data = node_data;

	parser_data->tail_node->node_data = node_data;

	parser_data->tail_node = node_data;

	hook_data->class = ELSE_CASE;
	hook_data->node_data = node_data;

	parser_data->level++;

	parser_data->head_line = line_root;
    }

    return status;
}


static int
set_data(struct parser_type *parser_data)
{
    int status;

    if (parser_data->attributes.variable_set.context) {
	status = net_data(parser_data);
    } else {
	status = map_data(parser_data);
    }

    return status;
}


static int
set_ever(struct parser_type *parser_data, struct hook_type *hook_data)
{
    const char *e;
    int status;
    int c;

    e = parser_data->program + 1;

    parser_data->slip(&e);

    c = *(const unsigned char *) e;
    if (c != 0x28) {
	status = _x1f4_c1_080707_error_5(parser_data->back_data, e);
    } else {
	parser_data->program = e;

	status = set_clip(parser_data, hook_data);
	if (status) {
	} else {
	    parser_data->level--;

	    status = fix_aime(parser_data, CASE_TEST);
	}
    }

    return status;
}


static int
set_hook(struct parser_type *parser_data, struct hook_type *hook_data)
{
    int class, status;

    class = hook_data->class;

    if (class == CASE_LOOP) {
	status = set_loop(parser_data, hook_data);
    } else if (class == ELSE_CASE) {
	status = set_none(parser_data, hook_data);
    } else if (class == CASE_POST) {
	status = set_post(parser_data, hook_data);
    } else {
	do {
	    const char *e;
	    int c;

	    e = parser_data->program + 1;

	    status = 0;

	    parser_data->slip(&e);

	    c = *(const unsigned char *) e;
	    if (c == 0x65) {
		e++;
		c = *(const unsigned char *) e;
		if (c == 0x6c) {
		    e++;
		    c = *(const unsigned char *) e;
		    if (c == 0x73) {
			e++;
			c = *(const unsigned char *) e;
			if (c == 0x65) {
			    e++;
			    c = *(const unsigned char *) e;
			    if (C_TYPE_X(parser_data->e_type_4, c)) {
				parser_data->slip(&e);
				c = *(const unsigned char *) e;
			    }
			    if (c == 0x7b) {
				parser_data->program = e;

				status = set_clip(parser_data, hook_data);

				break;
			    }
			}
		    } else {
			if (c == 0x69) {
			    e++;
			    c = *(const unsigned char *) e;
			    if (c == 0x66) {
				parser_data->program = e;

				status = set_ever(parser_data, hook_data);

				break;
			    }
			}
		    }
		}
	    }

	    status = set_test(parser_data, hook_data);
	} while (0);
    }

    return status;
}


static int
set_loop(struct parser_type *parser_data, struct hook_type *hook_data)
{
    int status;
    struct c1_node_type *node_data;

    status = ink_node(parser_data, &node_data, 1);
    if (status) {
    } else {
	struct c1_node_type *hook_node;

	hook_node = hook_data->node_data;

	node_data[0].state = 0;

	node_data[0].data.data = NULL;
	node_data[1].data.data = NULL;
	node_data[1].node_data = hook_node;

	hook_node[1].node_data = node_data;

	{
	    struct c1_node_type *tail_node;

	    tail_node = parser_data->tail_node;
	    if (tail_node) {
		tail_node->node_data = node_data;
	    } else {
		parser_data->head_node = node_data;
	    }

	    parser_data->tail_node = node_data;
	}

	parser_data->hook_data = hook_data->hook_data;

	parser_data->head_line = lock_root;

	parser_data->rack--;

	M_FREE(parser_data, hook_data);

	{
	    if (parser_data->head_rack) {
		net_red(parser_data);
	    }
	}
    }

    return status;
}


static int
set_none(struct parser_type *parser_data, struct hook_type *hook_data)
{
    int level;
    struct hook_type *hook_slip;

    hook_slip = parser_data->hook_slip;

    parser_data->hook_slip = hook_data;

    level = parser_data->level;

    do {
	struct hook_type *post_hook;

	post_hook = hook_data->hook_data;
	if (!post_hook) {
	    break;
	} else {
	    if (post_hook->level != level) {
		break;
	    } else {
		hook_data = post_hook;
	    }
	}
    } while (1);

    parser_data->hook_data = hook_data->hook_data;

    hook_data->hook_data = hook_slip;

    parser_data->head_line = lock_root;

    return 0;
}


static int
set_post(struct parser_type *parser_data, struct hook_type *hook_data)
{
    int status;

    do {
	const char *e;
	int c;

	e = parser_data->program + 1;

	parser_data->slip(&e);

	c = *(const unsigned char *) e;
	if (c == 0x77) {
	    e++;
	    c = *(const unsigned char *) e;
	    if (c == 0x68) {
		e++;
		c = *(const unsigned char *) e;
		if (c == 0x69) {
		    e++;
		    c = *(const unsigned char *) e;
		    if (c == 0x6c) {
			e++;
			c = *(const unsigned char *) e;
			if (c == 0x65) {
			    e++;
			    c = *(const unsigned char *) e;
			    if (C_TYPE_X(parser_data->e_type_4, c)) {
				parser_data->slip(&e);
				c = *(const unsigned char *) e;
			    }
			    if (c == 0x28) {
				parser_data->program = e;

				status = fix_half(parser_data, hook_data);

				break;
			    }
			}
		    }
		}
	    }
	}

	status = _x1f4_c1_080707_error_d(parser_data->back_data, e);
    } while (0);

    return status;
}


static int
set_test(struct parser_type *parser_data, struct hook_type *hook_data)
{
    struct hook_type *post_hook;

    (hook_data->node_data + 1)->node_data = parser_data->tail_node;

    post_hook = hook_data->hook_data;

    parser_data->hook_data = post_hook;

    parser_data->head_line = lock_root;

    M_FREE(parser_data, hook_data);

    if (post_hook) {
	int level;

	level = parser_data->level;

	if (post_hook->level == level) {
	    struct hook_type *hook_slip;

	    hook_slip = parser_data->hook_slip;

	    parser_data->hook_slip = post_hook;

	    do {
		hook_data = post_hook->hook_data;
		if (!hook_data) {
		    break;
		} else {
		    if (hook_data->level != level) {
			break;
		    } else {
			post_hook = hook_data;
		    }
		}
	    } while (1);

	    parser_data->hook_data = post_hook->hook_data;

	    post_hook->hook_data = hook_slip;
	}
    }

    return 0;
}


static void
air_fix(struct parser_type *parser_data)
{
    struct slip_type *slip_data;

    slip_data = parser_data->slip_data;
    while (slip_data) {
	struct slip_type *slip_free;

	slip_free = slip_data;
	slip_data = slip_data->last_slip;

	{
	    void *data;

	    data = (void *) slip_free->data;
	    if (data != parser_data->variable_deck) {
		x1f4_fini_mxdeck(&data);
	    }
	}

	M_FREE(parser_data, slip_free);
    }
}


static void
air_mae(struct c1_node_type *node_data, int (*free) (void *, void *),
	void *data)
{
    while (node_data) {
	struct c1_node_type *slip_node;

	slip_node = node_data;
	node_data = node_data->node_data;

	{
	    void *data;

	    data = slip_node->data.data;
	    if (data) {
		x1f4_fini_expression(&data);
	    } else {
		data = (slip_node + 1)->data.data;
		if (data) {
		    if (1) {
			x1f4_fini_expression(&data);
		    }
		}
	    }
	}

	free(data, slip_node);
    }
}


static void
air_set(struct c1_miss_type *miss_data, unsigned bits,
	int (*free) (void *, void *), void *data)
{
    while (miss_data) {
	struct c1_miss_type *miss_free;

	miss_free = miss_data;
	miss_data = miss_data->last_miss;
	if (1) {
	} else {
#if 0
	    free(data, miss_free->link);
#endif				/* 0 */
	}
	free(data, miss_free->data);
	free(data, miss_free);
    }
}


static void
fix_day(struct parser_type *parser_data, struct slip_type *slip_data)
{
    slip_data->count = parser_data->count;
    slip_data->trail = parser_data->count;
}


static void
fix_set(struct parser_type *parser_data)
{
    unsigned class = 0;

    if (1) {
	class |= 2;
    }
    {
	const struct c1_type_type *type_data;

	type_data = parser_data->type_data;
	if (type_data) {
	    const char *name;

	    name = type_data->name;
	    if (name) {
		do {
		    if (type_data->flat) {
			class |= 2;
			if (class & 1) {
			    break;
			}
		    }
		    if (type_data->line) {
			class |= 1;
			if (class & 2) {
			    break;
			}
		    }
		    {
			type_data++;
			name = type_data->name;
		    }
		} while (name);
	    }
	}
    }

    parser_data->class = class;
}


static void
net_red(struct parser_type *parser_data)
{
    struct hook_type *hook_data;
    unsigned level;

    level = parser_data->level;

    hook_data = parser_data->tail_rack;
    if (hook_data->level == level) {
	hook_data->hook_data = parser_data->hook_slip;

	hook_data = parser_data->head_rack;
	if (hook_data->level == level) {
	    parser_data->head_rack = NULL;
	    parser_data->tail_rack = NULL;
	} else {
	    struct hook_type *miss_hook;

	    miss_hook = hook_data;

	    do {
		hook_data = hook_data->hook_data;
		if (hook_data->level == level) {
		    parser_data->tail_rack = miss_hook;
		    if (1) {
			break;
		    }
		} else {
		    miss_hook = hook_data;
		}
	    } while (1);
	}

	parser_data->hook_slip = hook_data;
    }
}


static void
set_fix(struct parser_type *parser_data, unsigned count)
{
    int (*free) (void *, void *);
    struct c1_miss_type *miss_data;
    void *data;

    miss_data = parser_data->miss_data;

    parser_data->count -= count;

    data = parser_data->m.data;
    free = parser_data->m.free;

    while (count) {
	struct c1_miss_type *miss_free;

	miss_free = miss_data;
	miss_data = miss_data->last_miss;
#if __DEBUG_MISS__
	ddebug_1("freeing unused variable `%s'...\n",
		 ((struct x1f4_variable_type *) miss_free->data)->name);
#endif				/* __DEBUG_MISS__ */
	free(data, miss_free->data);
	free(data, miss_free);

	count--;
    }

    parser_data->miss_data = miss_data;
}


static void
way_far(const char **deck)
{
    const char *e;
    unsigned c;

    e = *deck;

    while (1) {
	c = *(const unsigned char *) e;
	if (C_TYPE_X(c_type_4, c)) {
	    e++;
	} else {
	    if (c ^ 35) {
		break;
	    } else {
		do {
		    ++e;
		    c = *(const unsigned char *) e;
		} while (c ^ 10);
	    }
	}
    }

    *deck = e;
}


static void
way_new(const char **deck)
{
    const char *e;
    unsigned c;

    e = *deck;

    c = *(const unsigned char *) e;
    while (C_TYPE_X(c_type_4, c)) {
	e++;
	c = *(const unsigned char *) e;
    }

    *deck = e;
}


static void
way_red(const char **deck)
{
    const char *e;
    unsigned c;

    e = *deck;

    c = *(const unsigned char *) e;
    if (C_TYPE_X(c_type_1, c)) {
	e++;
	c = *(const unsigned char *) e;
	while (C_TYPE_X(c_type_2, c)) {
	    e++;
	    c = *(const unsigned char *) e;
	}
    }

    *deck = e;
}


int
x1f4_fini_program(struct c1_program_type **program)
{
    struct c1_program_type *program_data;

    program_data = *program;

    {
	void *v1st;

	v1st = program_data->v1st;
	if (v1st) {
	    E_FREE(program_data, v1st);
	}
    }

    {
	void *v2nd;

	v2nd = program_data->v2nd;
	if (v2nd) {
	    E_FREE(program_data, v2nd);
	}
    }

    {
	void *flat;

	flat = program_data->flat;
	if (flat) {
	    _x1f4_c1_flat_mine(program_data, flat);
	}
    }

    air_mae(program_data->node, program_data->m.free, program_data->m.data);

    air_set(program_data->miss, program_data->bits, program_data->m.free,
	    program_data->m.data);

    if (1) {
	void *fine;

	fine = program_data->fine;
	if (fine) {
	    x1f4_fini_e4fine(&fine);
	}
    }

    E_FREE(program_data, program_data);

    return 0;
}


int
x1f4_inIt_program(struct c1_program_type **program, const char **proGram,
		  unsigned flags, const struct c1_context_type *context_data)
{
    int status;
    struct c1_program_type *program_data;
    struct parser_type parser;

    parser.e4_flags = X1f4_E4_ESTORAGE | X1f4_E4_MAXSTACK | X1f4_E4_TRANSFER;

    if (flags & RESOURCE_LINK) {
	map_zero(&parser, context_data);
    } else {
	parser.m.free = _x1f4_e4_free_data;
	parser.m.link = _x1f4_e4_link_data;
	parser.m.mode = _x1f4_e4_mode_data;
    }

    status = parser.m.link
	(parser.m.data, (void *) &program_data,
	 sizeof(struct c1_program_type));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	if (flags & DIRECT_ACCESS) {
	    parser.e4_flags |= X1f4_E4_DDACCESS;
	}
	if (flags & ERROR_STORAGE) {
	    parser.attributes.bcollect_set.eerecord_data =
		&((struct c1_back_type *)
		  context_data->link_e.back)->data.e_syntax.eerecord;
	    parser.back_data = context_data->link_e.back;
	    parser.e4_flags |= X1f4_E4_BCOLLECT;
	} else {
	    parser.back_data = NULL;
	}
	parser.e_type_4[0] = c_type_4[0];
	parser.e_type_4[1] = c_type_4[1];
	parser.e_type_4[2] = c_type_4[2];
	parser.e_type_4[3] = c_type_4[3];
	parser.e_type_4[4] = c_type_4[4];
	parser.e_type_4[5] = c_type_4[5];
	parser.e_type_4[6] = c_type_4[6];
	parser.e_type_4[7] = c_type_4[7];
	if (flags & COMPOSER_LINK) {
	    parser.attributes.composer_set.get = context_data->turn_0.get;
	    parser.attributes.composer_set.context =
		context_data->turn_0.context;
	    parser.e4_flags |= X1f4_E4_COMPOSER;
	}
	if (flags & DISPATCH_LINK) {
	    parser.base = *context_data->near_s.base;
	} else {
	    parser.base = (void *) (sizeof(void *) * X1f4_E4_USED_SIZE);
	}
	if (flags & IMPLICIT_LINK) {
	    parser.attributes.implicit_set.get = context_data->trap_0.get;
	    parser.attributes.implicit_set.context =
		context_data->trap_0.context;
	    parser.e4_flags |= X1f4_E4_IMPLICIT;
	}
	if (flags & SKIP_SCOMMENT) {
	    parser.e4_flags |= X1f4_E4_SCOMMENT;
	    parser.e_type_4[1] |= 8;
	    parser.slip = way_far;
	} else {
	    parser.slip = way_new;
	}
	if (flags & SUIT_SLIPTEST) {
	    parser.track = context_data->completion;
	} else {
	    parser.track = BYTE_COMPLETION;
	}
	if (flags & TEXTFLAT_LINK) {
	    program_data->x.data = context_data->call_e.data;
	    program_data->x.line = context_data->call_e.line;
	    program_data->x.post = context_data->call_e.post;
	    program_data->x.push = context_data->call_e.push;
	} else {
	    program_data->x.data = NULL;
	    program_data->x.line = NULL;
	    program_data->x.post = NULL;
	    program_data->x.push = NULL;
	}
	if (flags & TRANSFER_LINK) {
	    parser.e4fine = context_data->link_i.fine;
	} else {
	    parser.e4fine = NULL;
	}
	parser.attributes.completion = X1f4_E4_BACK_COMPLETION;
	parser.attributes.datalink_set.v1st = &parser.v1st;
	parser.attributes.datalink_set.v2nd = &parser.v2nd;
	parser.attributes.function_set.fix = context_data->last_0.fix;
	parser.attributes.function_set.get = context_data->last_0.get;
	parser.attributes.function_set.context =
	    context_data->last_0.context;
	parser.attributes.internal_set.s1st = &parser.s1st;
	parser.attributes.internal_set.s2nd = &parser.s2nd;
	parser.attributes.operator1s = context_data->operator1s;
	parser.attributes.operator2s = context_data->operator2s;
	parser.attributes.variable_set.get = _x1f4_c1_select_variable;
	parser.attributes.variable_set.context =
	    context_data->ever_0.context;
	parser.context_data = context_data;
	parser.flags = flags;
	parser.program = *proGram;
	parser.program_data = program_data;
	parser.r1st = 0;
	parser.r2nd = 0;
	parser.s1st = 0;
	parser.s2nd = 0;
	parser.shift = context_data->detail;
	parser.thirteen = parser.program;
	parser.v1st = NULL;
	parser.v2nd = NULL;
	parser.variable_deck = context_data->ever_0.context;
	program_data->bits = DISPATCH_LINK;
	program_data->fine = NULL;
	program_data->flat = NULL;
	program_data->line = NULL;
	program_data->m.data = parser.m.data;
	program_data->m.free = parser.m.free;
	program_data->m.link = parser.m.link;
	program_data->m.mode = parser.m.mode;
	program_data->miss = NULL;
	program_data->node = NULL;
	program_data->v1st = NULL;
	program_data->v2nd = NULL;
	if (flags & SIDELIST_LINK) {
	    parser.side_data = context_data->user_z.miss;
	} else {
	    parser.side_data = NULL;
	}
	if (0) {
	    parser.class = 0;
	    parser.type_data = NULL;
	} else {
	    if (flags & TYPELIST_LINK) {
		parser.type_data = context_data->user_w.miss;
		fix_set(&parser);
	    } else {
		parser.class = 1;
		parser.type_data = NULL;
	    }
	}
	status = max_data(&parser);
	if (status) {
	    x1f4_fini_program(&program_data);
	} else {
	    *program = program_data;
	    if (flags & DISPATCH_LINK) {
		*context_data->near_s.base = parser.base;
	    }
	}

	*proGram = parser.program;
    }

    return status;
}
