/*
 * c1.7.3.c
 * Copyright (C) 2006-2008, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <c1-parse.h>
#include <c1-types.h>

#define M_FREE(mcontext, mdata) \
    (mcontext)->m.free((mcontext)->m.data, (mdata))

void
_x1f4_c1_hook_node(void *parser, struct c1_node_type *node_data)
{
    struct hook_type *hook_data;

    hook_data = ((struct parser_type *) parser)->hook_slip;
    if (hook_data) {
	((struct parser_type *) parser)->hook_slip = NULL;

	do {
	    struct hook_type *miss_hook;

	    hook_data->node_data[1].node_data = node_data;

	    miss_hook = hook_data;
	    hook_data = hook_data->hook_data;
	    M_FREE((struct parser_type *) parser, miss_hook);
	} while (hook_data);
    }
}
