/*
 * c1.7.2.c
 * Copyright (C) 2006-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1-defs.h>
#include <c1-inter.h>
#include <c1-parse.h>
#include <c1-types.h>
#include <e4.h>

#define true(e)				1

#define FUN_FOR_ME \
    "____x1f4_c1_7_7_c_stupid_hack__();"

#define M_FREE(mcontext, mdata) \
    (mcontext)->m.free((mcontext)->m.data, (mdata))
#define M_LINK(mcontext, mdata, size) \
    (mcontext)->m.link((mcontext)->m.data, (void *) (mdata), (size))

#define line_copy(parser_data) \
    (((parser_data)->program - (parser_data)->thirteen) & LINE_COPY)

extern const struct x1f4_function_type _x1f4_c1_here_lead[];

static int deck_ever(const char *, unsigned, const void *,
		     const struct x1f4_variable_type **, void **);
static int deck_miss(struct parser_type *, struct c1_node_type *);
static int deck_none(const void *, const struct x1f4_function_type *, void **);
static int deck_this(const char *, unsigned, const void *,
		     const struct x1f4_function_type **);
static int line_miss(struct parser_type *);

static int
deck_ever(const char *context, unsigned miss, const void *text,
	  const struct x1f4_variable_type **variable, void **state)
{
    return 1;
}


static int
deck_miss(struct parser_type *parser_data, struct c1_node_type *node_data)
{
    int (*fix) (const void *, const struct x1f4_function_type *, void **),
	(*get) (const char *, unsigned, const void *,
		const struct x1f4_function_type **), status;
    struct x1f4_attributes_type *attributes;
    void *expression;
    const void *subtext;

    attributes = &parser_data->attributes;

    subtext = attributes->function_set.context;

    fix = attributes->function_set.fix;
    get = attributes->function_set.get;

    attributes->function_set.context = parser_data->program_data;

    attributes->function_set.fix = deck_none;
    attributes->function_set.get = deck_this;

    attributes->terminator = 0x3b;

    attributes->variable_set.get = deck_ever;

    status = x1f4_iNit_expression
	(&expression, FUN_FOR_ME, parser_data->e4_flags, attributes);
    if (status) {
	if (true(status == X1f4_E4_ALLOC_ERROR)) {
	    status = ALLOC_ERROR;
	}
    } else {
	node_data[0].data.data = expression;
    }

    attributes->function_set.fix = fix;
    attributes->function_set.get = get;

    attributes->function_set.context = subtext;

    attributes->variable_set.get = _x1f4_c1_select_variable;

    return status;
}


static int
deck_none(const void *context, const struct x1f4_function_type *function_data,
	  void **subtext)
{
    *subtext = (void *) context;

    return 0;
}


static int
deck_this(const char *none, unsigned miss, const void *text,
	  const struct x1f4_function_type **function)
{
    *function = _x1f4_c1_here_lead;

    return 0;
}


static int
line_miss(struct parser_type *parser_data)
{
    int status;
    struct c1_node_type *node_data;

    status = M_LINK(parser_data, &node_data, sizeof(struct c1_node_type));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	status = deck_miss(parser_data, node_data);
	if (status) {
	    status = ALLOC_ERROR;

	    M_FREE(parser_data, node_data);
	} else {
	    _x1f4_c1_hook_node(parser_data, node_data);

	    node_data[0].state = line_copy(parser_data);

	    {
		struct c1_node_type *tail_node;

		tail_node = parser_data->tail_node;
		if (tail_node) {
		    tail_node->node_data = node_data;
		} else {
		    parser_data->head_node = node_data;
		}

		parser_data->tail_node = node_data;
	    }
	}
    }

    return status;
}


int
_x1f4_c1_fit_trans(void *parser)
{
    return line_miss(parser);
}
