/*
 * c1.7.1.c
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TODO
 *
 * reorder variables so those needing processing come first and modify count to
 * indicate their number
 */

#include <c1-defs.h>
#include <c1-inter.h>
#include <c1-parse.h>
#include <c1-types.h>
#include <e4.h>

#define true(e)				1

#define FUN_FOR_ME \
    "____x1f4_c1_7_6_c_stupid_hack__();"

#define M_FREE(mcontext, mdata) \
    (mcontext)->m.free((mcontext)->m.data, (mdata))
#define M_LINK(mcontext, mdata, size) \
    (mcontext)->m.link((mcontext)->m.data, (void *) (mdata), (size))

#define line_copy(parser_data) \
    (((parser_data)->program - (parser_data)->thirteen) & LINE_COPY)

extern const struct x1f4_function_type _x1f4_c1_here_case[],
    _x1f4_c1_here_deck[];

static int deck_ever(const char *, unsigned, const void *,
		     const struct x1f4_variable_type **, void **);
static int deck_miss(struct parser_type *, void *, struct c1_node_type *);
static int deck_none(const void *, const struct x1f4_function_type *, void **);
static int deck_slip(const char *, unsigned, const void *,
		     const struct x1f4_function_type **);
static int deck_text(struct parser_type *, void *, struct c1_node_type *);
static int deck_this(const char *, unsigned, const void *,
		     const struct x1f4_function_type **);
static int line_miss(struct parser_type *, unsigned, struct c1_miss_type *);
static int line_text(struct parser_type *, unsigned, struct c1_miss_type *);
static int post_miss(struct parser_type *, unsigned, struct c1_miss_type *);
static int post_text(struct parser_type *, unsigned, struct c1_miss_type *);
static int slip_miss(struct parser_type *, unsigned, struct c1_miss_type *);
static int slip_text(struct parser_type *, unsigned, struct c1_miss_type *);

static int
deck_ever(const char *context, unsigned miss, const void *text,
	  const struct x1f4_variable_type **variable, void **state)
{
    return 1;
}


static int
deck_miss(struct parser_type *parser_data, void *text,
	  struct c1_node_type *node_data)
{
    int (*fix) (const void *, const struct x1f4_function_type *, void **),
	(*get) (const char *, unsigned, const void *,
		const struct x1f4_function_type **), status;
    struct x1f4_attributes_type *attributes;
    void *expression;
    const void *subtext;

    attributes = &parser_data->attributes;

    subtext = attributes->function_set.context;

    fix = attributes->function_set.fix;
    get = attributes->function_set.get;

    attributes->function_set.context = text;

    attributes->function_set.fix = deck_none;
    attributes->function_set.get = deck_this;

    attributes->terminator = 0x3b;

    attributes->variable_set.get = deck_ever;

    status = x1f4_iNit_expression
	(&expression, FUN_FOR_ME, parser_data->e4_flags, attributes);
    if (status) {
	if (true(status == X1f4_E4_ALLOC_ERROR)) {
	    status = ALLOC_ERROR;
	}
    } else {
	node_data[0].data.data = expression;
    }

    attributes->function_set.fix = fix;
    attributes->function_set.get = get;

    attributes->function_set.context = subtext;

    attributes->variable_set.get = _x1f4_c1_select_variable;

    return status;
}


static int
deck_none(const void *context, const struct x1f4_function_type *function_data,
	  void **subtext)
{
    *subtext = (void *) context;

    return 0;
}


static int
deck_slip(const char *none, unsigned miss, const void *text,
	  const struct x1f4_function_type **function)
{
    *function = _x1f4_c1_here_deck;

    return 0;
}


static int
deck_text(struct parser_type *parser_data, void *text,
	  struct c1_node_type *node_data)
{
    int (*fix) (const void *, const struct x1f4_function_type *, void **),
	(*get) (const char *, unsigned, const void *,
		const struct x1f4_function_type **), status;
    struct x1f4_attributes_type *attributes;
    void *expression;
    const void *subtext;

    attributes = &parser_data->attributes;

    subtext = attributes->function_set.context;

    fix = attributes->function_set.fix;
    get = attributes->function_set.get;

    attributes->function_set.context = text;

    attributes->function_set.fix = deck_none;
    attributes->function_set.get = deck_slip;

    attributes->terminator = 0x3b;

    attributes->variable_set.get = deck_ever;

    status = x1f4_iNit_expression
	(&expression, FUN_FOR_ME, parser_data->e4_flags, attributes);
    if (status) {
	if (true(status == X1f4_E4_ALLOC_ERROR)) {
	    status = ALLOC_ERROR;
	}
    } else {
	node_data[0].data.data = expression;
    }

    attributes->function_set.fix = fix;
    attributes->function_set.get = get;

    attributes->function_set.context = subtext;

    attributes->variable_set.get = _x1f4_c1_select_variable;

    return status;
}


static int
deck_this(const char *none, unsigned miss, const void *text,
	  const struct x1f4_function_type **function)
{
    *function = _x1f4_c1_here_case;

    return 0;
}


static int
line_miss(struct parser_type *parser_data, unsigned miss,
	  struct c1_miss_type *miss_data)
{
    int status;
    struct c1_node_type *node_data;

    status = M_LINK
	(parser_data, &node_data,
	 sizeof(struct c1_node_type) + sizeof(struct c1_half_type));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	struct c1_half_type *half_data;

	half_data = (struct c1_half_type *) (node_data + 1);

	status = deck_miss(parser_data, half_data, node_data);
	if (status) {
	    status = ALLOC_ERROR;

	    M_FREE(parser_data, node_data);
	} else {
	    _x1f4_c1_hook_node(parser_data, node_data);

	    node_data[0].state = line_copy(parser_data);

	    half_data->miss = miss_data;
	    half_data->size = miss;

	    {
		struct c1_node_type *tail_node;

		tail_node = parser_data->tail_node;
		if (tail_node) {
		    tail_node->node_data = node_data;
		} else {
		    parser_data->head_node = node_data;
		}

		parser_data->tail_node = node_data;
	    }
	}
    }

    return status;
}


static int
line_text(struct parser_type *parser_data, unsigned miss,
	  struct c1_miss_type *miss_data)
{
    int status;
    struct c1_node_type *node_data;

    status = M_LINK
	(parser_data, &node_data,
	 sizeof(struct c1_node_type) + sizeof(struct c1_half_type));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	struct c1_half_type *half_data;

	half_data = (struct c1_half_type *) (node_data + 1);

	status = deck_text(parser_data, half_data, node_data);
	if (status) {
	    status = ALLOC_ERROR;

	    M_FREE(parser_data, node_data);
	} else {
	    _x1f4_c1_hook_node(parser_data, node_data);

	    node_data[0].state = 0;

	    half_data->miss = miss_data;
	    half_data->post = parser_data->program_data;
	    half_data->size = miss;

	    {
		struct c1_node_type *tail_node;

		tail_node = parser_data->tail_node;
		if (tail_node) {
		    tail_node->node_data = node_data;
		} else {
		    parser_data->head_node = node_data;
		}

		parser_data->tail_node = node_data;
	    }
	}
    }

    return status;
}


static int
post_miss(struct parser_type *parser_data, unsigned miss,
	  struct c1_miss_type *miss_data)
{
    int false = 0;

    while (miss) {
	const struct c1_type_type *cell_type;

	cell_type = miss_data->type;
	if (cell_type) {
	    if (cell_type->flat) {
		false = 1;
		break;
	    } else {
	    }
	}

	miss--;

	miss_data = miss_data->last_miss;
    }

    return false;
}


static int
post_text(struct parser_type *parser_data, unsigned miss,
	  struct c1_miss_type *miss_data)
{
    int false = 0;

    while (miss) {
	if (((struct x1f4_variable_type *) miss_data->data)->type
	    == X1f4_E4_TEXT) {
	    false = 1;
	    break;
	}

	miss--;

	miss_data = miss_data->last_miss;
    }

    return false;
}


static int
slip_miss(struct parser_type *parser_data, unsigned miss,
	  struct c1_miss_type *miss_data)
{
    int status;

    if (post_miss(parser_data, miss, miss_data)) {
	status = line_miss(parser_data, miss, miss_data);
    } else {
	status = 0;
    }

    return status;
}


static int
slip_text(struct parser_type *parser_data, unsigned miss,
	  struct c1_miss_type *miss_data)
{
    int status;

    if (post_text(parser_data, miss, miss_data)) {
	status = line_text(parser_data, miss, miss_data);
    } else {
	status = 0;
    }

    return status;
}


int
_x1f4_c1_fit_sweep(void *parser, unsigned miss, struct c1_miss_type *miss_data)
{
    int status;

    status = slip_miss(parser, miss, miss_data);
    if (status) {
    } else {
	if (1) {
	    status = slip_text(parser, miss, miss_data);
	}
    }

    return status;
}
