/*
 * c1.5.c
 * Copyright (C) 2007-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1-types.h>
#include <e4.h>

extern const char *const x1f4_c1_empty_string;

int
x1f4_text_program(struct c1_program_type *program_data,
		  int (*free) (void *, void *), void *data)
{
    int status = 0;
    struct c1_miss_type *miss_data;

    miss_data = program_data->miss;

    while (miss_data) {
	if (((struct x1f4_variable_type *) miss_data->data)->type
	    == X1f4_E4_TEXT) {
	    X1f4_E4_C_TEXT text;
	    void *link;

	    link = miss_data->link;
	    text = *(X1f4_E4_C_TEXT *) link;
	    if (text != x1f4_c1_empty_string) {
		*(X1f4_E4_C_TEXT *) link = (char *) x1f4_c1_empty_string;
		status = free(data, text);
		if (status) {
		    break;
		}
	    }
	}

	miss_data = miss_data->last_miss;
    }

    return status;
}
