/*
 * c1.4.c
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stddef.h>

#if !defined HAVE_LIBx1f4i0
# include <akeylook-l.h>
#endif				/* !HAVE_LIBx1f4i0 */

static const struct x1f4_akeytree_type text_3[] = {
/* *INDENT-OFF* */
    {	"f",						NULL	},
    {	"nteger",					NULL	},
    {	NULL,						NULL	}
/* *INDENT-ON* */
}, text_2[] = {
/* *INDENT-OFF* */
    {	"al",						NULL	},
    {	"turn",						NULL	},
    {	NULL,						NULL	}
/* *INDENT-ON* */
}, text_1[] = {
/* *INDENT-OFF* */
    {	"if",						NULL	},
    {	"se",						NULL	},
    {	NULL,						NULL	}
/* *INDENT-ON* */
}, text_0[] = {
/* *INDENT-OFF* */
    {	"break",					NULL	},
    {	"cardinal",					NULL	},
    {	"do",						NULL	},
    {	"el",						text_1	},
    {	"i",						text_3	},
    {	"re",						text_2	},
    {	"text",						NULL	},
    {	"while",					NULL	},
    {	NULL,						NULL	}
/* *INDENT-ON* */
};

const struct x1f4_akeytree_type _x1f4_c1_text_root[] = {
/* *INDENT-OFF* */
    {	"",						text_0	},
    {	NULL,						NULL	}
/* *INDENT-ON* */
};
