/*
 * c1-v.8.c
 * Copyright (C) 2006-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <stdlib.h>

#include <c1-defs.h>
#include <c1-types.h>
#include <e4.h>
#include <mxdeck.h>

int
x1f4_link_variable(void **context, void *variable, const char *name,
		   unsigned length, int type, unsigned flags, void *storage)
{
    int status;
    struct c1_miss_type *miss_data;

    miss_data = (struct c1_miss_type *) malloc(sizeof(struct c1_miss_type));
    if (!miss_data) {
	status = FRAME_ERROR;
    } else {
	struct x1f4_variable_type *variable_data;

	variable_data = variable;

	if (1) {
	    do {
		void *deck, *text;

		text = *context;

		deck = text;
		if (deck) {
		} else {
		    status = x1f4_init_mxdeck(&deck, 0, NULL);
		    if (status) {
			break;
		    }
		}

		status = x1f4_post_mxpath(deck, name, length, miss_data);
		if (status) {
		    if (text) {
		    } else {
			x1f4_fini_mxdeck(&deck);
		    }
		} else {
		    if (text) {
		    } else {
			*context = deck;
		    }
		}
	    } while (0);
	    if (status) {
		free(miss_data);
		if (status == X1f4_MXDECK_EVER_MATCH) {
		    status = NAMES_CLASH;
		} else {
		    status = FRAME_ERROR;
		}
	    } else {
		variable_data->flags = flags;
		variable_data->length = length;
		variable_data->name = name;
		variable_data->type = type;

		miss_data->data = variable_data;
		miss_data->link = storage;
	    }
	}
    }

    return status;
}
