/*
 * c1-v.5.c
 * Copyright (C) 2008-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1-types.h>
#include <mxdeck.h>

typedef struct dawn_type {
    int (*list) (void *, void *, struct x1f4_variable_type *);
    void *data;
} dawn_type;

static int list_node(void *, const void *);

static int
list_node(void *dawn, const void *miss)
{
    struct c1_miss_type *miss_data;

    miss_data = (void *) miss;

    return ((struct dawn_type *) dawn)->list
	(((struct dawn_type *) dawn)->data, miss_data->link, miss_data->data);
}


int
x1f4_list_state(void *context, void *data,
		int (*list) (void *, void *, struct x1f4_variable_type *))
{
    struct dawn_type dawn;

    dawn.data = data;
    dawn.list = list;

    return x1f4_lime_mxdeck(context, &dawn, list_node);
}
