/*
 * c1-types.h
 * Copyright (C) 2006-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_c1_TYPES_H__
#define __LIBx1f4_c1_TYPES_H__

#include <c1-config.h>

#include <dt.h>
#include <e4.h>
#include <e4jack.h>
#include <track.h>

#define c1_type_type			x1f4_datatype_type

typedef struct c1_back_type {
    const char *line;
    struct {
	int (*rule) (void *, unsigned, unsigned);
	void *data;
    } hint;
    union {
	struct {
	    x1f4_eerecord_type eerecord;
	} e_syntax;
	struct {
	    x1f4_ejrecord_type ejrecord;
	} higherof;
	struct {
	    int slip, type;
	} m_return;
	struct {
	    unsigned size;
	} reserved;
	struct {
	    int type;
	} sidedata;
	struct {
	    unsigned size;
	} variable;
	struct {
	    int type;
	} w_scalar;
    } data;
    unsigned code, pick;
} c1_back_type;

typedef struct c1_context_type {
    int completion, detail;
    struct x1f4_track_type call_e;
    struct {
	int (*fix) (const void *, const struct x1f4_function_type *, void **),
	    (*get) (const char *, unsigned, const void *,
		    const struct x1f4_function_type **);
	const void *context;
    } last_0;
    struct {
	const void *context;
    } ever_0;
    struct {
	void *text;
    } link_g;
    struct {
	int (*get) (const void *, int, int,
		    const struct x1f4_operator_type **);
	const void *context;
    } trap_0;
    struct {
	int (*get) (const void *, int, int,
		    const struct x1f4_linetext_type **);
	const void *context;
    } turn_0;
    struct {
	void *back;
    } link_e;
    struct {
	void *fine;
    } link_i;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
    struct {
	int (*link) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **);
	void *data;
    } near_f;
    struct {
	void **base;
    } near_s;
    struct {
	const void *miss;
    } user_w;
    struct {
	const void *miss;
    } user_z;
    const struct x1f4_operator_type *const *operator1s, *const *operator2s;
} c1_context_type;

typedef struct c1_lead_type {
    union {
	X1f4_E4_C_MODE mode;
	X1f4_E4_C_REAL real;
	X1f4_E4_C_TEXT text;
	X1f4_E4_C_USER user;
    } data;
} c1_lead_type;

typedef struct c1_miss_type {
    struct c1_miss_type *last_miss;
    void *data, *link;
    const void *type;
} c1_miss_type;

typedef struct c1_node_type {
    struct c1_node_type *node_data;
    union {
	unsigned l;
	void *data;
    } data;
    unsigned state;
} c1_node_type;

typedef struct c1_program_type {
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } m;
    struct {
	int (*near) (void *, void *, void *);
	void *data;
    } u;
    union {
	struct {
	    int (*link) (void *, void **, unsigned);
	} c;
	struct {
	    int (*pick) (void *, void ***, int (*) (void *), unsigned,
			 void **);
	    const void *text;
	} f;
    } v;
    struct x1f4_track_type x;
    unsigned bits;
    unsigned post;
#if __SAVE_STACK_SIZE__
    unsigned s1st, s2nd;
#endif				/* __SAVE_STACK_SIZE__ */
    unsigned used;
    void *fine, *flat, *high, *line, *miss, *node, *slip, *v1st, *v2nd;
} c1_program_type;

#endif				/* __LIBx1f4_c1_TYPES_H__ */
