/*
 * c1-parse.h
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_c1_PARSE_H__
#define __LIBx1f4_c1_PARSE_H__

#include <e4.h>
#include <c1-types.h>
#include <trans.h>

/*
 * FEATURES
 *
 * Uh, these structures were not meant for use outside c1.7.c, hence are not
 * properly prefixed.  keep your fingers crossed!
 */

typedef struct c1_half_type {
    unsigned size;
    void *miss, *post;
} c1_half_type;

typedef struct hook_type {
    int class, level;
    struct c1_node_type *node_data;
    struct hook_type *hook_data;
} hook_type;

typedef struct parser_type {
    const char *program, *thirteen;
    int class, level, shift, side, track;
    struct c1_back_type *back_data;
    const struct c1_context_type *context_data;
    struct c1_miss_type *miss_data;
    struct c1_node_type *head_node, *tail_node;
    struct c1_program_type *program_data;
    const struct c1_type_type *cell_type, *side_data, *type_data;
    struct hook_type *head_rack, *hook_data, *hook_slip, *tail_rack;
    struct slip_type *slip_data;
    struct trans_type m;
    struct x1f4_attributes_type attributes;
    const struct x1f4_ckeytree_type *head_line;
    struct x1f4_vkeytree_type *variable_tree;
    const struct x1f4_vkeytree_type *variable_deck;
    unsigned count, e4_flags, e_type_4[8], flags, r1st, r2nd, rack, s1st, s2nd;
    void *base, *e4fine, (*slip) (const char **), *v1st, *v2nd;
} parser_type;

#endif				/* __LIBx1f4_c1_PARSE_H__ */
