/*
 * c1-e.9.c
 * Copyright (C) 2006-2010, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */

#include <c1-types.h>
#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-f.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <e4.h>
#include <e42.h>

static int print_head(void *, int (*) (void *, const char *, unsigned),
		      unsigned);

static void set_index(unsigned *, struct c1_node_type *,
		      struct c1_node_type *);

static int
print_head(void *data, int (*this) (void *, const char *, unsigned),
	   unsigned width)
{
    int status;

    if (!width) {
	status = 0;
    } else {
	do {
	    unsigned trans;

	    if (width < 16) {
		trans = width;
	    } else {
		trans = 16;
	    }

	    status = this(data, "                ", trans);
	    if (status) {
		break;
	    } else {
		width -= trans;
	    }
	} while (width);
    }

    return status;
}


static void
set_index(unsigned *index, struct c1_node_type *seek_node,
	  struct c1_node_type *node_data)
{
    unsigned i = 0;

    while (node_data != seek_node) {
	i++;
	node_data = node_data->node_data;
    }

    *index = i;
}


int
x1f4_vprint_bprogram(void *data, int (*this) (void *, const char *, unsigned),
		     struct c1_program_type *program_data, unsigned flags,
		     unsigned width)
{
    int status;
    struct c1_node_type *node_data;

    node_data = program_data->node;
    if (!node_data) {
	status = 0;
    } else {
	unsigned i = 0;

	do {
	    status = x1f4_vprint_fcardinal(data, this, 0, width, 10, i);
	    if (status) {
		break;
	    } else {
		status = this(data, " ", 1);
		if (status) {
		    break;
		} else {
		    void *miss;

		    miss = node_data->data.data;
		    if (miss) {
			status = x1f4_vprint_expression
			    (data, this, miss, flags);
			if (status) {
			    break;
			} else {
			    status = this(data, "\n", 1);
			    if (status) {
				break;
			    }
			}
		    } else {
			unsigned shift;

			node_data++;

			miss = node_data->data.data;
			if (!miss) {
			    status = this(data, "GOTO ", 5);
			    if (status) {
				break;
			    } else {
				shift = 0;
			    }
			} else {
			    status = this(data, "IF !(", 5);
			    if (status) {
				break;
			    } else {
				status = x1f4_vprint_expression
				    (data, this, miss, flags);
				if (status) {
				    break;
				} else {
				    status = this(data, ")\n", 2);
				    if (status) {
					break;
				    } else {
					status = print_head(data, this, width);
					if (status) {
					    break;
					} else {
					    status = this
						(data, "     GOTO ", 10);
					    if (status) {
						break;
					    } else {
						shift = 1;
					    }
					}
				    }
				}
			    }
			}

			{
			    unsigned index;

			    set_index(&index, node_data->node_data,
				      program_data->node);
			    status = x1f4_vprint_fcardinal
				(data, this, 0, width, 10, index + shift);
			    if (status) {
				break;
			    } else {
				status = this(data, "\n", 1);
				if (status) {
				    break;
				}
			    }
			}

			node_data--;
		    }

		    i++;

		    node_data = node_data->node_data;
		}
	    }
	} while (node_data);
	if (!status) {
	    status = x1f4_vprint_fcardinal(data, this, 0, width, 10, i);
	    if (!status) {
		status = this(data, "\n", 1);
	    }
	}
    }

    return status;
}
