/*
 * c1-e.8.c
 * Copyright (C) 2006-2010, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#include <c1-inter.h>
#include <c1-types.h>
#include <e4.h>
#include <e42.h>

#define LOOP				0
#define NONE				1
#define POST				2
#define TEST				3

#define true(e)				1

#define trans(a, c)			((a) - (c))
/*
 * cute, but wrong...
 * (works only when the size of int matches the size of pointer)
 */
#undef trans
#define trans(a, c)			((a) < (c) ? -1 : (c) < (a) ? 1 : 0)

typedef struct link_type {
    int used;
    const struct x1f4_variable_type *variable_data;
} link_type;

typedef struct list_type {
    int slip;
    struct link_type *link_data;
    unsigned deck;
} list_type;

typedef struct post_type {
    union {
	struct c1_node_type *node_data;
	unsigned link;
    } data;
    struct c1_node_type *node_data;
    struct post_type *post_data;
} post_type;

typedef struct tail_type {
    int type;
    struct c1_node_type *node_data;
    struct link_type *link_data;
    struct tail_type *tail_data;
    unsigned deck;
} tail_type;

static int class_linkage(const void *, const void *);
static int class_program(struct link_type **, unsigned *,
			 struct c1_miss_type *);
static int frame_address(void *, int (*) (void *, const char *, unsigned),
			 struct c1_node_type *, struct c1_node_type *, int *);
static int frame_depress(void *, int (*) (void *, const char *, unsigned),
			 int *);
static int frame_linkage(void *, int (*) (void *, const char *, unsigned),
			 struct link_type **, unsigned *,
			 struct c1_node_type *, struct c1_node_type *,
			 struct post_type *, unsigned, struct c1_node_type *,
			 int, struct tail_type **);
static int frame_regress(void *, int (*) (void *, const char *, unsigned),
			 int *);
static int merge_inverse(struct post_type **, struct post_type **,
			 struct post_type *, struct c1_node_type *,
			 struct c1_node_type *);
static int merge_reverse(struct post_type **, struct post_type **,
			 struct c1_node_type *);
static int print_linkage(void *, int (*) (void *, const char *, unsigned),
			 struct link_type **, unsigned *,
			 struct c1_node_type *, struct c1_node_type *,
			 struct post_type *, unsigned);
static int print_program(void *, int (*) (void *, const char *, unsigned),
			 struct link_type *, unsigned, struct c1_node_type *,
			 struct post_type *, struct post_type *, unsigned);
static int space_linkage(const void *, const void *);
static int trans_linkage(const void *, const void *);

static void back_linkage(struct list_type *, const struct c1_node_type *,
			 const struct c1_node_type *, struct post_type **,
			 int *);
static void free_reverse(struct post_type *);
static void half_linkage(struct list_type *, const struct c1_node_type *,
			 const struct c1_node_type *, struct post_type **);
static void head_linkage(struct list_type *, const struct c1_node_type *,
			 const struct c1_node_type *, struct post_type **);
static void join_linkage(struct link_type **, unsigned *, struct tail_type **);
static void link_address(struct tail_type *, struct c1_node_type *,
			 struct post_type *);
static void list_linkage(struct list_type *, const struct c1_node_type *,
			 const struct c1_node_type *, struct post_type **);
static void miss_linkage(void *, const struct x1f4_variable_type *);
static void post_linkage(struct list_type *, const struct c1_node_type *,
			 const struct c1_node_type *, struct post_type **);
static void slip_linkage(void *, const struct x1f4_variable_type *);

static int
class_linkage(const void *major, const void *minor)
{
    const struct x1f4_variable_type *Major, *Minor;
    int class;

    Major = ((const struct link_type *) major)->variable_data;
    Minor = ((const struct link_type *) minor)->variable_data;

    class = Major->type - Minor->type;
    if (!class) {
	const unsigned char *s, *v;

	s = (const void *) Major->name;
	v = (const void *) Minor->name;

	while (1) {
	    unsigned char c;

	    c = *s;
	    if (c ^ *v) {
		class = (int) c - (int) *v;
		if (1) {
		    break;
		}
	    } else {
		if (c) {
		    s++;
		    v++;
		} else {
		    class = 0;
		    if (2) {
			break;
		    }
		}
	    }
	}
    }

    return class;
}


static int
class_program(struct link_type **link, unsigned *deck,
	      struct c1_miss_type *miss_data)
{
    int status;
    unsigned slip = 0;

    {
	struct c1_miss_type *miss_deck;

	miss_deck = miss_data;
	while (miss_deck) {
	    miss_deck = miss_deck->last_miss;
	    slip++;
	}
    }
    if (!slip) {
	*deck = 0;
	*link = NULL;

	status = 0;
    } else {
	struct link_type *link_data;

	link_data = (struct link_type *)
	    malloc(sizeof(struct link_type) * slip);
	if (!link_data) {
	    status = -1;
	} else {
	    status = 0;

	    *deck = slip;
	    *link = link_data;

	    while (miss_data) {
		link_data->variable_data = miss_data->data;
		link_data++;
		miss_data = miss_data->last_miss;
	    }
	}
    }

    return status;
}


static int
frame_address(void *data, int (*this) (void *, const char *, unsigned),
	      struct c1_node_type *node_data, struct c1_node_type *post_node,
	      int *type)
{
    int status;

    if (post_node->data.data) {
	status = frame_depress(data, this, type);
    } else {
	if ((post_node + 1)->data.data) {
	    status = frame_depress(data, this, type);
	} else {
	    if ((post_node + 1)->node_data != node_data) {
		status = frame_depress(data, this, type);
	    } else {
#if 0
		struct c1_node_type *quit_node;

		quit_node = node_data->node_data;
		while (quit_node != post_node) {
		    if (quit_node->data.data) {
			quit_node = quit_node->node_data;
		    } else {
			quit_node++;
			if (quit_node->data.data) {
			    if (quit_node->node_data == post_node) {
				break;
			    }
			}

			quit_node = quit_node->node_data->node_data;
		    }
		}

		if (quit_node != post_node) {
		    status = frame_depress(data, this, type);
		} else {
#endif				/* 0 */
		    status = frame_regress(data, this, type);
#if 0
		}
#endif				/* 0 */
	    }
	}
    }

    return status;
}


static int
frame_depress(void *data, int (*this) (void *, const char *, unsigned),
	      int *type)
{
    int status;

    status = this(data, "if (", 4);
    if (!status) {
	*type = TEST;
    }

    return status;
}


static int
frame_linkage(void *data, int (*this) (void *, const char *, unsigned),
	      struct link_type **link, unsigned *deck,
	      struct c1_node_type *node_data, struct c1_node_type *rack_node,
	      struct post_type *post_data, unsigned level,
	      struct c1_node_type *post_node, int type,
	      struct tail_type **tail)
{
    int status;

    do {
	struct link_type *link_swap;
	unsigned swap;

	link_swap = *link;

	swap = *deck;

	if (swap) {
	    status = print_linkage
		(data, this, link, deck, node_data, rack_node, post_data,
		 level);
	    if (status) {
		break;
	    }
	}

	{
	    struct tail_type *tail_data;

	    tail_data = (struct tail_type *) malloc(sizeof(struct tail_type));
	    if (!tail_data) {
		status = -1;
		break;
	    } else {
		status = 0;

		tail_data->tail_data = *tail;

		*tail = tail_data;

		tail_data->type = type;

		tail_data->deck = swap;

		tail_data->link_data = link_swap;
		tail_data->node_data = post_node;
	    }
	}
    } while (0);

    return status;
}


static int
frame_regress(void *data, int (*this) (void *, const char *, unsigned),
	      int *type)
{
    int status;

    status = this(data, "while (", 7);
    if (!status) {
	*type = LOOP;
    }

    return status;
}


static int
merge_inverse(struct post_type **head, struct post_type **tail,
	      struct post_type *tail_tail, struct c1_node_type *swap_node,
	      struct c1_node_type *slip_node)
{
    int status;
    struct post_type *head_head, *tail_head;

    head_head = *head;
    tail_head = *tail;

    do {
	{
	    struct post_type *post_tail;

	    post_tail = tail_tail->post_data;
	    if (post_tail) {
		struct c1_node_type *node_data, *slip_node;

		slip_node = post_tail->node_data;
		node_data = slip_node->node_data + 1;
		if (swap_node == node_data->node_data) {
		    status = merge_inverse
			(&head_head, &tail_head, post_tail, swap_node,
			 slip_node);
		    if (status) {
			break;
		    }
		}
	    }
	}
	{
	    struct post_type *post_data;

	    post_data = (struct post_type *) malloc(sizeof(struct post_type));
	    if (!post_data) {
		status = -1;
		break;
	    } else {
		status = 0;

		post_data->data.node_data = slip_node;

		post_data->node_data = swap_node;

		tail_tail->data.link = 1;

		if (!head_head) {
		    head_head = post_data;
		} else {
		    tail_head->post_data = post_data;
		}

		tail_head = post_data;
	    }
	}
    } while (0);

    *head = head_head;
    *tail = tail_head;

    return status;
}


static int
merge_reverse(struct post_type **head, struct post_type **tail,
	      struct c1_node_type *node_data)
{
    int status = 0;

    if (!node_data) {
	*head = NULL;
	*tail = NULL;
    } else {
	struct c1_node_type *swap_node;
	struct post_type *head_tail = NULL, *tail_tail = NULL;

	swap_node = node_data;

	while (node_data) {
	    if (node_data->data.data) {
		node_data = node_data->node_data;
	    } else {
		if (!(node_data + 1)->data.data) {
		    node_data = node_data->node_data;
		} else {
		    struct c1_node_type *slip_node;

		    slip_node = node_data->node_data;
		    if (slip_node) {
			if ((node_data + 1)->node_data == slip_node) {
			    if (!slip_node->data.data) {
				struct post_type *post_data;

				post_data = (struct post_type *)
				    malloc(sizeof(struct post_type));
				if (!post_data) {
				    status = -1;
				    break;
				} else {
				    post_data->node_data = node_data;

				    post_data->data.link = 0;

				    if (!head_tail) {
					head_tail = post_data;
				    } else {
					tail_tail->post_data = post_data;
				    }

				    tail_tail = post_data;
				}
			    }
			}
		    }

		    node_data = slip_node;
		}
	    }
	}
	if (!head_tail) {
	    if (!status) {
		*head = NULL;
		*tail = NULL;
	    }
	} else {
	    tail_tail->post_data = NULL;

	    if (status) {
		free_reverse(head_tail);
	    } else {
		struct post_type *head_head = NULL, *slip_post, *slip_tail,
		    *tail_head = NULL;

		slip_tail = head_tail;
		slip_post = slip_tail;

		while (swap_node) {
		    tail_tail = head_tail;
		    while (tail_tail) {
			struct c1_node_type *slip_node;

			slip_node = tail_tail->node_data;
			node_data = slip_node->node_data + 1;
			if (swap_node == node_data->node_data) {
			    status = merge_inverse
				(&head_head, &tail_head, tail_tail, swap_node,
				 slip_node);

			    break;
			} else {
			    tail_tail = tail_tail->post_data;
			}
		    }

		    if (status) {
			break;
		    } else {
			struct c1_node_type *slip_node;

			slip_node = swap_node->node_data;
			if (slip_node) {
			    if ((swap_node + 1)->node_data == slip_node) {
				if (!slip_node->data.data) {
				    if (slip_tail->node_data == swap_node) {
					if (slip_tail->data.link) {
					    slip_post = slip_tail;
					    slip_tail = slip_tail->post_data;
					} else {
					    if (slip_tail == head_tail) {
						slip_tail =
						    slip_tail->post_data;
						free(head_tail);
						head_tail = slip_tail;
						if (!head_tail) {
						    break;
						}
						slip_post = head_tail;
					    } else {
						struct post_type *swap_post;

						swap_post = slip_tail;
						slip_tail =
						    slip_tail->post_data;
						free(swap_post);
						slip_post->post_data =
						    slip_tail;
					    }
					}
				    }
				}
			    }
			}

			swap_node = swap_node->node_data;
		    }
		}

		if (head_head) {
		    tail_head->post_data = NULL;
		}

		if (!status) {
		    *head = head_head;
		    *tail = head_tail;
		} else {
		    if (head_head) {
			free_reverse(head_head);
		    }
		    if (1) {
			free_reverse(head_tail);
		    }
		}
	    }
	}
    }

    return status;
}


static int
print_linkage(void *data, int (*this) (void *, const char *, unsigned),
	      struct link_type **link, unsigned *deck,
	      struct c1_node_type *node_data, struct c1_node_type *rack_node,
	      struct post_type *post_data, unsigned level)
{
    int status;
    struct link_type *link_data;
    unsigned slip;

    link_data = *link;
    slip = *deck;

    qsort(link_data, slip, sizeof(struct link_type), trans_linkage);

    {
	struct link_type *link_slip;
	unsigned i;

	link_slip = link_data;

	i = slip;
	for (; i; i--) {
	    link_slip->used = 0;
	    link_slip++;
	}
    }

    {
	struct list_type list;

	list.link_data = link_data;
	list.deck = slip;
	list.slip = 0;

	do {
	    do {
		if (post_data) {
		    if (post_data->node_data == node_data) {
			struct c1_node_type *post_node;

			post_node = post_data->data.node_data;

			post_data = post_data->post_data;

			post_linkage(&list, node_data, post_node, &post_data);
			node_data = post_node;

			x1f4_list_expression
			    ((node_data + 1)->data.data, &list, miss_linkage);

			node_data = node_data->node_data->node_data;

			break;
		    }
		}
		{
		    void *miss;

		    miss = node_data->data.data;
		    if (miss) {
			x1f4_list_expression(miss, &list, miss_linkage);
		    } else {
			node_data++;

			miss = node_data->data.data;
			if (!miss) {
			    node_data--;
			} else {
			    struct c1_node_type *post_node;

			    x1f4_list_expression
				(node_data->data.data, &list, miss_linkage);

			    post_node = node_data->node_data;

			    node_data--;

			    if (node_data != post_node) {
				if (post_node->data.data) {
				    head_linkage
					(&list, node_data, post_node,
					 &post_data);
				    node_data = post_node;
				} else if ((post_node + 1)->data.data) {
				    head_linkage
					(&list, node_data, post_node,
					 &post_data);
				    node_data = post_node;
				} else {
				    int back;

				    back_linkage
					(&list, node_data, post_node,
					 &post_data, &back);
				    node_data = post_node;
				    /*
				     * TODO
				     *
				     * since for now I cannot tell whether this
				     * is an if-else sequence or an if-break
				     * (or a while-break sequence)
				     * I'll just skip it...
				     *
				     * looking for:
				     *     Test
				     *     Jump (forward)
				     * candidates:
				     *.
				     *     if
				     *     else
				     *.
				     *     if
				     *         break
				     *.
				     *     while
				     *         break
				     *
				     * of these, the third can be discriminated
				     * againt the others.
				     */
				    back = 1;
				    if (!back) {
					post_node = (post_node + 1)->node_data;
					half_linkage
					    (&list, node_data, post_node,
					     &post_data);
					node_data = post_node;

					break;
				    }
				}
			    }
			}
		    }

		    node_data = node_data->node_data;
		}
	    } while (0);
	} while (node_data != rack_node);
    }

    {
	struct link_type *head_link, *tail_link;
	unsigned diff;

	diff = slip;

	head_link = link_data;
	tail_link = link_data + diff - 1;

	while (diff) {
	    if (!~head_link->used) {
		head_link++;
		diff--;
	    } else {
		while (diff) {
		    if (~tail_link->used) {
			tail_link--;
			diff--;
		    } else {
			const struct x1f4_variable_type *variable_data;

			variable_data = head_link->variable_data;
			head_link->variable_data = tail_link->variable_data;
			tail_link->variable_data = variable_data;

			head_link++;
			tail_link--;
			diff -= 2;

			break;
		    }
		}
	    }
	}

	diff = head_link - link_data;
	if (!diff) {
	    status = 0;
	} else {
	    *deck = slip - diff;
	    *link = head_link;

	    qsort(link_data, diff, sizeof(struct link_type), class_linkage);

	    {
		int type = X1f4_E4_LAST;

		do {
		    const struct x1f4_variable_type *variable_data;

		    variable_data = link_data->variable_data;

		    {
			int line;

			line = variable_data->type;
			if (line != type) {
			    if (type != X1f4_E4_LAST) {
				status = this(data, ";\n", 2);
				if (status) {
				    break;
				}
			    }

			    if (level) {
				status =
				    _x1f4_c1_print_level(data, this, level);
				if (status) {
				    break;
				}
			    }

			    type = line;
			    switch (type) {
			    case X1f4_E4_MODE:
				status = this(data, "mode ", 5);
				break;
			    case X1f4_E4_REAL:
				status = this(data, "real ", 5);
				break;
			    default:
				status = this(data, "text ", 5);
			    }
			    {
				if (status) {
				    break;
				}
			    }
			} else {
			    {
				status = this(data, ", ", 2);
				if (status) {
				    break;
				}
			    }
			}
		    }

		    status = this
			(data, variable_data->name, variable_data->length);
		    if (status) {
			break;
		    }

		    diff--;

		    link_data++;
		} while (diff);
		if (!status) {
		    status = this(data, ";\n\n", 3);
		}
	    }
	}
    }

    return status;
}


static int
print_program(void *data, int (*this) (void *, const char *, unsigned),
	      struct link_type *link_data, unsigned deck,
	      struct c1_node_type *node_data, struct post_type *head_post,
	      struct post_type *tail_post, unsigned flags)
{
    int status = 0, swap = 0;
    struct tail_type *head_tail = NULL;
    unsigned level = 0;

    do {
	int hack = 0, jump, less = 0;
	void *miss;

	if (head_post) {
	    while (1) {
		if (head_post->node_data != node_data) {
		    break;
		} else {
		    if (level) {
			status = _x1f4_c1_print_level(data, this, level);
			if (status) {
			    break;
			}
		    }

		    status = this(data, "do {\n", 5);
		    if (status) {
			break;
		    } else {
			struct c1_node_type *post_node;

			level++;

			post_node = head_post->data.node_data;

			head_post = head_post->post_data;

			if (post_node == node_data) {
			    hack = 1;
			} else {
			    status = frame_linkage
				(data, this, &link_data, &deck, node_data,
				 post_node, head_post, level, post_node, POST,
				 &head_tail);
			    if (status) {
				break;
			    }
			}

			if (!head_post) {
			    break;
			}
		    }
		}
	    }
	    if (status) {
		break;
	    }
	}

	miss = node_data->data.data;
	if (miss) {
	    if (level) {
		status = _x1f4_c1_print_level(data, this, level);
		if (status) {
		    break;
		}
	    }

	    jump = 0;

	    status = x1f4_vprint_expression(data, this, miss, flags);
	    if (status) {
		break;
	    } else {
		status = this(data, ";\n", 2);
		if (status) {
		    break;
		}
	    }
	} else {
	    miss = (node_data + 1)->data.data;

	    if (!miss) {
		if (!swap) {
		    do {
			if (head_tail) {
			    if (node_data == head_tail->node_data) {
				if (head_tail->type != NONE) {
				    break;
				}
			    }
			}

			if (true(level)) {
			    status = _x1f4_c1_print_level(data, this, level);
			    if (status) {
				break;
			    }
			}
			status = this(data, "break;\n", 7);
		    } while (0);
		    if (status) {
			break;
		    }
		}

		jump = !swap;
	    } else {
		jump = 0;

		do {
		    if (tail_post) {
			if (tail_post->node_data == node_data) {
			    level--;

			    if (level) {
				status = _x1f4_c1_print_level
				    (data, this, level);
				if (status) {
				    break;
				}
			    }

			    status = this(data, "} while (", 9);
			    if (status) {
				break;
			    } else {
				status = x1f4_vprint_expression
				    (data, this, miss, flags);
				if (status) {
				    break;
				} else {
				    status = this(data, ");\n", 3);
				    if (status) {
					break;
				    } else {
					tail_post = tail_post->post_data;

					less = 1;

					if (!hack) {
					    join_linkage(&link_data, &deck,
							 &head_tail);
					}
				    }
				}
			    }

			    break;
			}
		    }
		    {
			int type;
			struct c1_node_type *post_node;

			if (level) {
			    status = _x1f4_c1_print_level(data, this, level);
			    if (status) {
				break;
			    }
			}

			post_node = (node_data + 1)->node_data;

			status = frame_address
			    (data, this, node_data, post_node, &type);
			if (status) {
			    break;
			} else {
			    status = x1f4_vprint_expression
				(data, this, miss, flags);
			    if (status) {
				break;
			    } else {
				status = this(data, ") {\n", 4);
				if (status) {
				    break;
				} else {
				    if (post_node == node_data) {
					if (level) {
					    status = _x1f4_c1_print_level
						(data, this, level);
					    if (status) {
						break;
					    }
					}
					status = this(data, "}\n", 2);
					if (status) {
					    break;
					}
				    } else {
					level++;

					status = frame_linkage
					    (data, this, &link_data, &deck,
					     node_data->node_data,
					     post_node->node_data, head_post,
					     level, post_node, type,
					     &head_tail);
					if (status) {
					    break;
					}
				    }
				}
			    }
			}
		    }
		} while (0);
		if (status) {
		    break;
		}
	    }
	}

	if (head_tail) {
	    do {
		if (node_data != head_tail->node_data) {
		    break;
		} else {
		    level--;
		    do {
			if (jump) {
			    if (head_tail->type == LOOP) {
				jump = 0;
			    } else if (head_tail->type == NONE) {
			    } else if (head_tail->type == TEST) {
				struct tail_type *tail_data;


				tail_data = head_tail->tail_data;
				if (tail_data) {
				    struct c1_node_type *post_node;

				    post_node = (node_data + 1)->node_data;

				    do {
					int type;

					type = tail_data->type;
					if (type == LOOP) {
					    struct c1_node_type *slip_node;

					    slip_node = tail_data->node_data;
					    slip_node = slip_node->node_data;
					    if (post_node == slip_node) {
						break;
					    }
					} else if (type == POST) {
					    struct c1_node_type *slip_node;

					    slip_node = tail_data->node_data;
					    slip_node = slip_node->node_data;
					    slip_node = slip_node->node_data;
					    if (post_node == slip_node) {
						break;
					    }
					}

					tail_data = tail_data->tail_data;
				    } while (tail_data);
				}
				if (tail_data) {
				    /*
				     * TODO
				     *
				     * some extra (harmless?) breaks are
				     * printed.
				     *
				     * for an instance:
				     *
				     * while (1) {
				     *     if (1) {
				     *         if (1) {
				     *             if (1) {
				     *                 break;
				     *             }
				     *         }
				     *     }
				     * }
				     *
				     * is printed as:
				     *
				     * while (1) {
				     *     if (1) {
				     *         if (1) {
				     *             if (1) {
				     *                 break;
				     *             }
				     *             break;
				     *         }
				     *         break;
				     *     }
				     * }
				     *
				     * crap!
				     */
				    status = _x1f4_c1_print_level
					(data, this, level + 1);
				    if (status) {
					break;
				    } else {
					status = this(data, "break;\n", 7);
					if (status) {
					    break;
					}
				    }
				} else {
				    if (level) {
					status = _x1f4_c1_print_level
					    (data, this, level);
					if (status) {
					    break;
					}
				    }
				    status = this(data, "} else {\n", 9);
				    if (status) {
					break;
				    } else {
					struct c1_node_type *post_node;

					post_node = (node_data + 1)->node_data;

					if (post_node
					    == node_data->node_data) {
					} else {
					    link_address(head_tail, node_data,
							 head_post);

					    level++;

					    status = print_linkage
						(data, this, &link_data, &deck,
						 node_data->node_data,
						 post_node, head_post, level);

					    break;
					}
				    }
				}
			    }
			}

			if (level) {
			    status = _x1f4_c1_print_level(data, this, level);
			    if (status) {
				break;
			    }
			}
			status = this(data, "}\n", 2);
			if (status) {
			    break;
			} else {
			    join_linkage(&link_data, &deck, &head_tail);
			}
		    } while (0);
		    if (status) {
			break;
		    }
		}
	    } while (head_tail);
	    if (status) {
		break;
	    }
	}

	swap = less;

	node_data = node_data->node_data;
    } while (node_data);

    if (head_tail) {
	do {
	    struct tail_type *tail_data;

	    tail_data = head_tail;
	    head_tail = head_tail->tail_data;
	    free(tail_data);
	} while (head_tail);
    }

    return status;
}


static int
space_linkage(const void *major, const void *minor)
{
    return trans((const struct x1f4_variable_type *) major,
		 ((const struct link_type *) minor)->variable_data);
}


static int
trans_linkage(const void *major, const void *minor)
{
    return trans(((const struct link_type *) major)->variable_data,
		 ((const struct link_type *) minor)->variable_data);
}


static void
back_linkage(struct list_type *list_data, const struct c1_node_type *node_data,
	     const struct c1_node_type *post_node, struct post_type **post,
	     int *out)
{
    int back = 0;
    struct c1_node_type *head_node;
    struct post_type *post_data;

    head_node = (post_node + 1)->node_data;

    list_data->slip++;

    if (node_data == head_node) {
	back = 1;
    }

    post_data = *post;

    node_data = node_data->node_data;

    while (node_data != post_node) {
	do {
	    if (post_data) {
		if (post_data->node_data == node_data) {
		    struct c1_node_type *miss_node;

		    miss_node = post_data->data.node_data;

		    post_data = post_data->post_data;

		    list_linkage(list_data, node_data, miss_node, &post_data);
		    node_data = miss_node;

		    x1f4_list_expression
			((node_data + 1)->data.data, list_data, miss_linkage);

		    node_data = node_data->node_data;
		    if (node_data == post_node) {
			back = 1;
		    } else {
			node_data = node_data->node_data;
		    }

		    break;
		}
	    }
	    {
		void *miss;

		if (node_data == head_node) {
		    back = 1;
		}

		miss = node_data->data.data;
		if (miss) {
		    x1f4_list_expression(miss, list_data, slip_linkage);
		} else {
		    miss = (node_data + 1)->data.data;
		    if (miss) {
			x1f4_list_expression(miss, list_data, slip_linkage);
		    }
		}

		node_data = node_data->node_data;
	    }
	} while (0);
    }

    *out = back;

    *post = post_data;
}


static void
free_reverse(struct post_type *post_data)
{
    while (post_data) {
	struct post_type *slip_post;

	slip_post = post_data;
	post_data = post_data->post_data;
	free(slip_post);
    }
}


static void
half_linkage(struct list_type *list_data, const struct c1_node_type *node_data,
	     const struct c1_node_type *post_node, struct post_type **post)
{
    struct post_type *post_data;

    list_data->slip++;

    post_data = *post;

    node_data = node_data->node_data;

    while (node_data != post_node) {
	do {
	    if (post_data) {
		if (post_data->node_data == node_data) {
		    struct c1_node_type *miss_node;

		    miss_node = post_data->data.node_data;

		    post_data = post_data->post_data;

		    list_linkage(list_data, node_data, miss_node, &post_data);
		    node_data = miss_node;

		    x1f4_list_expression
			((node_data + 1)->data.data, list_data, miss_linkage);

		    node_data = node_data->node_data->node_data;

		    break;
		}
	    }
	    {
		void *miss;

		miss = node_data->data.data;
		if (miss) {
		    x1f4_list_expression(miss, list_data, slip_linkage);
		} else {
		    miss = (node_data + 1)->data.data;
		    if (miss) {
			x1f4_list_expression(miss, list_data, slip_linkage);
		    }
		}

		node_data = node_data->node_data;
	    }
	} while (0);
    }

    *post = post_data;
}


static void
head_linkage(struct list_type *list_data, const struct c1_node_type *node_data,
	     const struct c1_node_type *post_node, struct post_type **post)
{
    struct post_type *post_data;

    list_data->slip++;

    post_data = *post;

    do {
	do {
	    if (post_data) {
		if (post_data->node_data == node_data) {
		    struct c1_node_type *miss_node;

		    miss_node = post_data->data.node_data;

		    post_data = post_data->post_data;

		    list_linkage(list_data, node_data, miss_node, &post_data);
		    node_data = miss_node;

		    x1f4_list_expression
			((node_data + 1)->data.data, list_data, miss_linkage);

		    node_data = node_data->node_data->node_data;

		    break;
		}
	    }
	    {
		void *miss;

		node_data = node_data->node_data;

		miss = node_data->data.data;
		if (miss) {
		    x1f4_list_expression(miss, list_data, slip_linkage);
		} else {
		    miss = (node_data + 1)->data.data;
		    if (miss) {
			x1f4_list_expression(miss, list_data, slip_linkage);
		    }
		}
	    }
	} while (0);
    } while (node_data != post_node);

    *post = post_data;
}


static void
join_linkage(struct link_type **link, unsigned *deck, struct tail_type **tail)
{
    struct tail_type *head_tail;

    head_tail = *tail;

    *deck = head_tail->deck;

    *link = head_tail->link_data;

    *tail = head_tail->tail_data;

    free(head_tail);
}


static void
link_address(struct tail_type *head_tail, struct c1_node_type *node_data,
	     struct post_type *head_post)
{
    struct c1_node_type *head_node, *link_node, *rack_node;

    head_node = (node_data + 1)->node_data;

    rack_node = node_data;
    link_node = rack_node->node_data;
    while (link_node != head_node) {
#if 1
	rack_node = link_node;
	link_node = rack_node->node_data;
#else
	do {
	    if (head_post) {
		if (head_post->node_data == link_node) {
		    /*
		     * ...
		     */
		}
	    }
	    {
		if (link_node->data.data) {
		    rack_node = link_node;
		} else {
		    link_node++;
		    rack_node = link_node->node_data;
		    if (rack_node == head_node) {
			link_node--;
			rack_node = link_node;
		    } else {
			if (!rack_node->data.data) {
			    struct c1_node_type *case_node;

			    link_node--;
			    rack_node++;
			    case_node = rack_node->node_data;
			    if (case_node == link_node) {
				rack_node--;
			    } else {
				if (case_node == head_node) {
				    rack_node--;
				} else {
				    rack_node = case_node;
				}
			    }
			}
		    }
		}

		link_node = rack_node->node_data;
	    }
	} while (0);
#endif				/* 1 */
    }

    head_tail->type = NONE;

    head_tail->node_data = rack_node;
}


static void
list_linkage(struct list_type *list_data, const struct c1_node_type *node_data,
	     const struct c1_node_type *post_node, struct post_type **post)
{
    struct post_type *post_data;

    post_data = *post;

    while (node_data != post_node) {
	do {
	    if (post_data) {
		if (post_data->node_data == node_data) {
		    struct c1_node_type *miss_node;

		    miss_node = post_data->data.node_data;

		    post_data = post_data->post_data;

		    list_linkage(list_data, node_data, miss_node, &post_data);
		    node_data = miss_node;

		    x1f4_list_expression
			((node_data + 1)->data.data, list_data, miss_linkage);

		    node_data = node_data->node_data->node_data;

		    break;
		}
	    }
	    {
		void *miss;

		miss = node_data->data.data;
		if (miss) {
		    x1f4_list_expression(miss, list_data, slip_linkage);
		} else {
		    miss = (node_data + 1)->data.data;
		    if (miss) {
			x1f4_list_expression(miss, list_data, slip_linkage);
		    }
		}

		node_data = node_data->node_data;
	    }
	} while (0);
    }

    *post = post_data;
}


static void
miss_linkage(void *list, const struct x1f4_variable_type *variable_data)
{
    struct link_type *link_data;
    struct list_type *list_data;

    list_data = list;

    link_data = bsearch
	(variable_data, list_data->link_data, list_data->deck,
	 sizeof(struct link_type), space_linkage);
    if (link_data) {
	link_data->used = ~0;
    }
}


static void
post_linkage(struct list_type *list_data, const struct c1_node_type *node_data,
	     const struct c1_node_type *post_node, struct post_type **post)
{
    list_data->slip++;

    list_linkage(list_data, node_data, post_node, post);
}


static void
slip_linkage(void *list, const struct x1f4_variable_type *variable_data)
{
    struct link_type *link_data;
    struct list_type *list_data;

    list_data = list;

    link_data = bsearch
	(variable_data, list_data->link_data, list_data->deck,
	 sizeof(struct link_type), space_linkage);
    if (link_data) {
	int deck;

	deck = link_data->used;
	if (~deck) {
	    if (!deck) {
		link_data->used = list_data->slip;
	    } else {
		if (deck != list_data->slip) {
		    link_data->used = ~0;
		}
	    }
	}
    }
}


int
x1f4_vprint_program(void *data, int (*this) (void *, const char *, unsigned),
		    struct c1_program_type *program_data, unsigned flags)
{
    int status;
    struct c1_node_type *node_data;

    /*
     * this function is to buggy anyhow
     * and supports no user types...
     */
    return -1;

    node_data = program_data->node;
    if (!node_data) {
	status = 0;
    } else {
	struct link_type *link_data;
	unsigned deck;

	status = class_program(&link_data, &deck, program_data->miss);
	if (!status) {
	    struct post_type *head_post, *tail_post;

	    status = merge_reverse(&head_post, &tail_post, node_data);
	    if (!status) {
		struct link_type *link_deck;

		link_deck = link_data;
		status = print_linkage
		    (data, this, &link_deck, &deck, node_data, NULL, head_post,
		     0);
		if (!status) {
		    status = print_program
			(data, this, link_deck, deck, node_data, head_post,
			 tail_post, flags);
		}

		if (tail_post) {
		    free_reverse(tail_post);
		}
		if (head_post) {
		    free_reverse(head_post);
		}
	    }

	    if (link_data) {
		free(link_data);
	    }
	}
    }

    return status;
}
