/*
 * c1-defs.h
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_c1_DEFS_H__
#define __LIBx1f4_c1_DEFS_H__

/*
 * error definitions
 */
#define ALLOC_ERROR			1
#define PARSE_ERROR			2

/*
 * completion definitions
 */
#define BACK_COMPLETION			0
#define BYTE_COMPLETION			1
#define TURN_COMPLETION			2

/*
 * generation flag definitions
 */
#define COMPOSER_LINK			(1L << 0x1)
#define DIRECT_ACCESS			(1L << 0x2)
#define DISPATCH_LINK			(1L << 0x3)
#define ERROR_STORAGE			(1L << 0x0)
#define IMPLICIT_LINK			(1L << 0x4)
#define LEAD_DATATEXT			(1L << 0x5)
#define LINE_OPTIMIZE			(1L << 0x6)
#define RESOURCE_LINK			(1L << 0x7)
#define SIDELIST_LINK			(1L << 0x9)
#define SKIP_SCOMMENT			(1L << 0x8)
#define SUIT_SLIPTEST			(1L << 0xa)
#define TEXTFLAT_LINK			(1L << 0xb)
#define TRANSFER_LINK			(1L << 0xc)
#define TURNCAST_LINK			(1L << 0xd)
#define TYPELIST_LINK			(1L << 0xe)

/*
 * node state bit definitions
 */
#define LINE_COPY			((1L << 0x1c) - 1)

/*
 * record definitions
 */
#define HINT_MASK			(1L << 0x0)

/*
 * variables collections construction error definitions
 */
#define FRAME_ERROR			1
#define NAMES_CLASH			2

#endif				/* __LIBx1f4_c1_DEFS_H__ */
