/*
 * bqpx.v.c
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bcount.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-types.h>

#define __HALF_TRANSFER__		1

#define __UNROLL_TRANSFER__		0

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_gray_bqpset(void *bqfset, integral_q **lead, void *node,
		       unsigned *mile, integral_q **lock, integral_q **lane,
		       unsigned *rate)
{
    integral_q *club, *file, last, *tier;
    unsigned copy, deck, ever, pick;

    club = *lead;

    file = *lock;

    tier = *lane;

    pick = *mile;

    copy = *rate;

    if (copy) {
	integral_q *fast;

	*KD(file) = Lx55555555;

	fast = file + copy;

	deck = (copy - 2) >> 1;

#if __UNROLL_TRANSFER__
# error
#else
	for (; deck; deck--) {
	    *fast = *(fast - 2);
	    fast -= 2;
	}
#endif				/* __UNROLL_TRANSFER__ */
	{
	    *fast = KD(node)[pick];
	}
    } else {
    }
    if (1) {
	{
	    KD(node)[pick] = *(club + integral_q_bits - 2);
	}

	*KD(club) = Lx55555555 ^ Q(1) << (integral_q_bits - 2);
    }

    tier = file;

    file = club;

    pick--;

    club = ND(node)[pick - 1];

    last = *club & ~Lx55555555;
    if (last) {
#if __HALF_TRANSFER__
	if (1) {
	    integral_q *fast, *side, text;

	    fast = file;

	    fast += integral_q_bits - 2;

	    ever = (integral_q_bits - 2 - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
	    for (; ever; ever--) {
		*fast = *(fast - 2);
		fast -= 2;
	    }
# endif				/* __UNROLL_TRANSFER__ */

	    fast = file;

	    l2_q_bitcount(deck, last);

	    if (deck < 4) {
		deck = 1;

		*KD(fast) = Lx55555555;

		fast += 2;
	    } else {
		deck &= ~1;

		*KD(fast) = Lx55555555
		    | ((Q(1) << (deck - 2)) - 1);

		if (deck < 8) {
		    deck >>= 1;

		    fast += deck;
		} else {
		    fast += deck - 3;

		    side = fast - 1;

		    deck >>= 1;

		    ever = deck - 3;
		    for (; ever; ever--) {
			*fast = *side;
			side -= 2;
			fast--;
		    }
		}
	    }

	    *fast = KD(node)[pick];

	    fast--;

	    deck--;

	    side = club;

	    text = *side;

	    side += integral_q_bits;

	    while (deck & ~1) {
		if (text & Q(1) << integral_q_last) {
		    side--;
		    *fast = *side;
		    fast--;
		    side--;
		    *fast = *side;
		    fast--;

		    deck -= 2;
		} else {
		    deck--;

		    side -= 2;
		    *fast = *side;
		    fast--;
		}

		text <<= 2;
	    }
	    if (deck) {
		if (text & Q(1) << integral_q_last) {
		    side--;
		    *fast = *side;
		    side--;
		    KD(node)[pick] = *side;

		    deck = 0;
		} else {
		    side -= 2;
		    *fast = *side;
		}

		text <<= 2;
	    } else {
		deck = 1;
	    }
	    if (deck) {
		if (text & Q(1) << integral_q_last) {
		    side--;
		    KD(node)[pick] = *side;

		    side--;

		    fast = club + integral_q_bits - 2;

		    text <<= 1;
		} else {
		    side -= 2;
		    KD(node)[pick] = *side;

		    side--;

		    fast = club + integral_q_bits - 2;

		    text <<= 2;

		    if (side < fast) {
			if (text & Q(1) << integral_q_last) {
			    *fast = *side;
			    fast -= 2;
			}

			side--;

			text <<= 1;
		    }
		}
	    } else {
		side--;

		fast = club + integral_q_bits - 2;

		if (side < fast) {
		    if (text & Q(1) << integral_q_last) {
			*fast = *side;
			fast -= 2;
		    }

		    side--;

		    text <<= 1;
		}
	    }
	    while (side < fast) {
		if (text & Q(1) << (integral_q_bits - 2)) {
		    *fast = *side;
		    fast -= 2;
		    side--;
		    *fast = *side;
		    fast -= 2;
		    side--;
		} else {
		    *fast = *side;
		    fast -= 2;
		    side -= 2;
		}

		text <<= 2;
	    }

	    *KD(club) &= Lx55555555 | ((Q(1) << (fast - club)) - 1);
	}
#else
# error
#endif				/* __HALF_TRANSFER__ */
    } else {
	*rate = integral_q_bits - 2;

	*mile = pick;

	*lane = tier;

	*lock = file;

	*lead = club;
    }

    return 0;
}
