/*
 * bqpx.u.c
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bcount.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-types.h>

#define __HALF_TRANSFER__		1

#define __UNROLL_TRANSFER__		0

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_blue_bqpset(void *bqfset, integral_q **lead, void *node,
		       unsigned *mile, integral_q **lock, integral_q **lane,
		       unsigned *rate)
{
    integral_q *club, *file, next, *tier;
    unsigned copy, deck, ever, pick;

    club = *lead;

    file = *lock;

    tier = *lane;

    pick = *mile;

    copy = *rate;

    if (1) {
	integral_q *fast;

	*KD(file) = Lx55555555;

	fast = file + copy;

	deck = (integral_q_bits - copy - 2) >> 1;

#if __UNROLL_TRANSFER__
# error
#else
	for (; deck; deck--) {
	    *fast = *(fast + 2);
	    fast += 2;
	}
#endif				/* __UNROLL_TRANSFER__ */
	{
	    *fast = KD(node)[pick + 1];
	}

	{
	    KD(node)[pick + 1] = *(tier + 2);
	}

	*KD(tier) = Lx55555555 ^ Q(4);
    }

    if (1) {
	club = file;

	file = tier;
    } else {
    }

    pick++;

    tier = ND(node)[pick + 1];

    next = *tier & ~Lx55555555;
    if (next) {
#if __HALF_TRANSFER__
	if (1) {
	    integral_q *fast, *side, text;

	    fast = file;

	    fast += 2;

	    deck = (integral_q_bits - 2 - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
	    for (; deck; deck--) {
		*fast = *(fast + 2);
		fast += 2;
	    }
# endif				/* __UNROLL_TRANSFER__ */

	    fast = file;

	    l2_q_bitcount(ever, next);

	    if (ever < 4) {
		ever = 1;

		*KD(fast) = Lx55555555;

		fast += integral_q_bits - 2;
	    } else {
		ever &= ~1;

		*KD(fast) = Lx55555555
		    | ~Q(0) << (integral_q_bits - ever + 2);

		if (ever < 8) {
		    ever >>= 1;

		    fast += integral_q_bits - ever;
		} else {
		    fast += integral_q_bits - ever + 3;

		    side = fast + 1;

		    ever >>= 1;

		    deck = ever - 3;
		    for (; deck; deck--) {
			*fast = *side;
			side += 2;
			fast++;
		    }
		}
	    }

	    *fast = KD(node)[pick + 1];

	    fast++;

	    ever--;

	    side = tier;

	    text = *side;

	    while (ever & ~1) {
		if (text & Q(2)) {
		    side++;
		    *fast = *side;
		    fast++;
		    side++;
		    *fast = *side;
		    fast++;

		    ever -= 2;
		} else {
		    ever--;

		    side += 2;
		    *fast = *side;
		    fast++;
		}

		text >>= 2;
	    }
	    if (ever) {
		if (text & Q(2)) {
		    side++;
		    *fast = *side;
		    side++;
		    KD(node)[pick + 1] = *side;

		    ever = 0;
		} else {
		    side += 2;
		    *fast = *side;
		}

		text >>= 2;
	    } else {
		ever = 1;
	    }
	    if (ever) {
		if (text & Q(2)) {
		    side++;
		    KD(node)[pick + 1] = *side;

		    side++;

		    fast = tier + 2;

		    text >>= 1;
		} else {
		    side += 2;
		    KD(node)[pick + 1] = *side;

		    side++;

		    fast = tier + 2;

		    text >>= 2;

		    if (fast < side) {
			text >>= 1;
			if (text & Q(1)) {
			    *fast = *side;
			    fast += 2;
			} else {
			}

			side++;
		    }
		}
	    } else {
		side++;

		fast = tier + 2;

		if (fast < side) {
		    text >>= 1;
		    if (text & Q(1)) {
			*fast = *side;
			fast += 2;
		    } else {
		    }

		    side++;
		}
	    }
	    while (fast < side) {
		if (text & Q(4)) {
		    *fast = *side;
		    fast += 2;
		    side++;
		    *fast = *side;
		    fast += 2;
		    side++;
		} else {
		    *fast = *side;
		    fast += 2;
		    side += 2;
		}

		text >>= 2;
	    }

	    *KD(tier) &= Lx55555555 | ~Q(0) << 2 << (fast - tier - 2);
	}
#else
# error
#endif				/* __HALF_TRANSFER__ */
    } else {
	*rate = 2;

	*mile = pick;

	*lane = tier;

	*lock = file;

	*lead = club;
    }

    return 0;
}
