/*
 * bqpx.s.c
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_fold_bqpset(void *bqfset, integral_q *club, integral_q *file,
		       integral_q *tier, unsigned pick, unsigned copy,
		       void *node)
{
    int status;
    unsigned deck;

    if (pick) {
	integral_q bill, *fast, *side;

	fast = club;

	side = node;

	*side = integral_q_bits - 2;

	side++;

	bill = *side;

	deck = half_integral_q_bits - 1;
	for (; deck; deck--) {
	    fast += 2;
	    *side = *fast;
	    side++;
	}

	{
	    *side = bill;
	}

	fast = file + 2;

	deck = (copy - 2) >> 1;
	for (; deck; deck--) {
	    side++;
	    *side = *fast;
	    fast += 2;
	}

	deck = (integral_q_bits - copy - 2) >> 1;
	for (; deck; deck--) {
	    side++;
	    fast += 2;
	    *side = *fast;
	}

	{
	    int excess;

	    bqfset(bqfset)->link_a.fpnews.link_v.rate = 0;

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, club);
	    if (status) {
		status = FREE_ERROR;
	    }

	    excess = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (excess) {
		status = FREE_ERROR;
	    }
	}
    } else {
	integral_q bill, *fast, *side;

	fast = file + 2;

	side = node;

	*side = integral_q_bits - 2;

	side++;

	bill = *side;

	deck = (copy - 2) >> 1;
	for (; deck; deck--) {
	    *side = *fast;
	    fast += 2;
	    side++;
	}

	deck = (integral_q_bits - copy - 2) >> 1;
	for (; deck; deck--) {
	    fast += 2;
	    *side = *fast;
	    side++;
	}

	{
	    *side = bill;
	}

	fast = tier;

	deck = half_integral_q_bits - 1;
	for (; deck; deck--) {
	    side++;
	    fast += 2;
	    *side = *fast;
	}

	{
	    int excess;

	    bqfset(bqfset)->link_a.fpnews.link_v.rate = 0;

	    status = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, file);
	    if (status) {
		status = FREE_ERROR;
	    }

	    excess = bqfset(bqfset)->link_m.free
		(bqfset(bqfset)->link_m.data, tier);
	    if (excess) {
		status = FREE_ERROR;
	    }
	}
    }

    return status;
}
